/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.view;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import nu.mine.mosher.graph.datawebapp.util.Props;
import nu.mine.mosher.graph.datawebapp.util.Utils;
import nu.mine.mosher.graph.datawebapp.view.PageList;
import nu.mine.mosher.graph.datawebapp.view.PageView;
import nu.mine.mosher.graph.datawebapp.view.SecurePage;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;

public class PageEdit
extends SecurePage {
    private final Serializable entity;
    private boolean isNew;
    private boolean isBad;

    public PageEdit(Class cls, Long id, UUID uuid) {
        this.isNew = Objects.isNull(id);
        this.entity = this.isNew ? Utils.create(cls) : Utils.same(uuid, Utils.ogm().load(cls, (Serializable)id));
        this.add(new Component[]{new Label("entity", (Serializable)((Object)cls.getSimpleName()))});
        this.add(new Component[]{new FormEntity()});
    }

    private final class FormEntity
    extends Form<Serializable> {
        public FormEntity() {
            super("form", (IModel)Model.of((Serializable)PageEdit.this.entity));
            this.add(new Component[]{new ListView<Props.Prop>("properties", Utils.props().properties(PageEdit.this.entity.getClass())){

                protected void populateItem(ListItem<Props.Prop> item) {
                    CheckBox property;
                    Fragment fragment;
                    Props.Prop prop = (Props.Prop)item.getModelObject();
                    Label name = new Label("name", (Serializable)((Object)prop.name));
                    item.add(new Component[]{name});
                    PropertyModel model = new PropertyModel((Object)PageEdit.this.entity, prop.name);
                    if (prop.isBoolean) {
                        fragment = new Fragment("entry", "entryCheckbox", (MarkupContainer)FormEntity.this);
                        property = new CheckBox("property", (IModel)model);
                    } else {
                        fragment = new Fragment("entry", "entryText", (MarkupContainer)FormEntity.this);
                        property = new TextField("property", (IModel)model);
                    }
                    if (prop.readOnly) {
                        property.setEnabled(false);
                    }
                    fragment.add(new Component[]{property});
                    item.add(new Component[]{fragment});
                }
            }.setReuseItems(true)});
            this.add(new Component[]{new SubmitLink("cancel"){

                public void onSubmit() {
                    FormEntity.this.next();
                }
            }.setDefaultFormProcessing(false)});
        }

        protected void onSubmit() {
            PageEdit.this.isBad = true;
            try {
                Utils.ogm().save((Object)PageEdit.this.entity);
                Utils.store().dropSession();
                PageEdit.this.isNew = false;
                PageEdit.this.isBad = false;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.next();
        }

        private void next() {
            if (PageEdit.this.isBad) {
                this.setResponsePage((IRequestablePage)new PageView(PageEdit.this.entity));
            } else if (PageEdit.this.isNew) {
                this.setResponsePage((IRequestablePage)new PageList(PageEdit.this.entity.getClass()));
            } else {
                this.setResponsePage((IRequestablePage)new PageView(PageEdit.this.entity.getClass(), Utils.id(PageEdit.this.entity), Utils.uuid(PageEdit.this.entity)));
            }
        }
    }
}

