/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nu.mine.mosher.graph.datawebapp.store.Store;
import nu.mine.mosher.graph.datawebapp.util.ReadOnly;

public final class Props {
    private final Store store;

    public Props(Store store) {
        this.store = store;
    }

    public List<Ref> refsMultiple(Class cls) {
        return Props.collections(cls).filter(f -> this.isEntity(Props.getGenType(f))).map(f -> new Ref(f.getName(), Props.getGenType(f), true)).collect(Collectors.toList());
    }

    public List<Ref> refsSingular(Class cls) {
        return Props.scalars(cls).filter(f -> this.isEntity(f.getType())).map(f -> new Ref(f.getName(), f.getType(), false)).collect(Collectors.toList());
    }

    public List<Prop> properties(Class cls) {
        return Props.scalars(cls).filter(f -> !this.isEntity(f.getType())).map(f -> new Prop(f.getName(), f.isAnnotationPresent(ReadOnly.class), Props.isBoolean(f))).collect(Collectors.toList());
    }

    private static boolean isBoolean(Field f) {
        return f.getType().equals(Boolean.TYPE) || Boolean.class.isAssignableFrom(f.getType());
    }

    private boolean isEntity(Class cls) {
        return this.store.isEntity(cls);
    }

    private static Stream<Field> scalars(Class cls) {
        return Props.props(cls).filter(f -> !f.getType().isArray()).filter(f -> !Collection.class.isAssignableFrom(f.getType())).filter(f -> !Optional.class.isAssignableFrom(f.getType()));
    }

    private static Stream<Field> collections(Class cls) {
        return Props.props(cls).filter(f -> Collection.class.isAssignableFrom(f.getType()));
    }

    private static Stream<Field> props(Class cls) {
        return Arrays.stream(cls.getFields()).filter(f -> !f.isSynthetic()).filter(f -> !Modifier.isStatic(f.getModifiers()));
    }

    private static Class getGenType(Field field) {
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        return (Class)stringListType.getActualTypeArguments()[0];
    }

    public static class Ref
    implements Serializable {
        public final String name;
        public final Class cls;
        public final boolean collection;

        private Ref(String name, Class cls, boolean collection) {
            this.name = name;
            this.cls = cls;
            this.collection = collection;
        }
    }

    public static class Prop
    implements Serializable {
        public final String name;
        public final boolean readOnly;
        public final boolean isBoolean;

        public Prop(String name, boolean readOnly, boolean isBoolean) {
            this.name = name;
            this.readOnly = readOnly;
            this.isBoolean = isBoolean;
        }
    }
}

