/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.store;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import nu.mine.mosher.graph.datawebapp.util.Utils;
import org.apache.wicket.model.PropertyModel;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.event.EventListenerAdapter;

public class Neo4jConnection
implements AutoCloseable {
    private final SessionFactory factory;
    private final Session session;

    public Neo4jConnection(String url, String username, String password, String ... packages) {
        Configuration config = new Configuration.Builder().useNativeTypes().strictQuerying().uri(url).credentials(username, password).build();
        this.factory = new SessionFactory(config, packages);
        this.factory.register((EventListener)new EventListenerAdapter(){

            public void onPreSave(Event event) {
                new PropertyModel(event.getObject(), "utcModified").setObject((Object)ZonedDateTime.now(ZoneOffset.UTC));
            }
        });
        this.session = this.factory.openSession();
        this.session.query("CALL dbms.showCurrentUser()", Collections.emptyMap(), true);
        this.createFullTextIndex();
    }

    @Override
    public void close() {
        this.factory.close();
    }

    public Session session() {
        return this.session;
    }

    public MetaData metadata() {
        return this.factory.metaData();
    }

    private void createFullTextIndex() {
        String csvIndexProperties = Optional.ofNullable(Utils.app().getInitParameter("index-properties")).orElse("name");
        List<String> idxProperties = Arrays.asList(csvIndexProperties.split(","));
        if (this.missing("fulltextNode")) {
            String queryNod = "CALL db.index.fulltext.createNodeIndex(\"fulltextNode\", $entities, $properties)";
            this.session.query(Void.TYPE, "CALL db.index.fulltext.createNodeIndex(\"fulltextNode\", $entities, $properties)", Map.of("entities", this.namesNodes(), "properties", idxProperties));
        }
        if (this.missing("fulltextRelationship")) {
            String queryRel = "CALL db.index.fulltext.createRelationshipIndex(\"fulltextRelationship\", $entities, $properties)";
            this.session.query(Void.TYPE, "CALL db.index.fulltext.createRelationshipIndex(\"fulltextRelationship\", $entities, $properties)", Map.of("entities", this.namesRelationships(), "properties", idxProperties));
        }
    }

    private boolean missing(String name) {
        String query = "CALL db.indexes() YIELD indexName WHERE indexName=$name RETURN COUNT(*)";
        Iterable result = this.session.query(Integer.TYPE, "CALL db.indexes() YIELD indexName WHERE indexName=$name RETURN COUNT(*)", Map.of("name", name));
        int count = (Integer)result.iterator().next();
        return count == 0;
    }

    public List<String> namesNodes() {
        return this.factory.metaData().persistentEntities().stream().filter(ci -> this.isNodeEntity(ci.getUnderlyingClass())).map(ClassInfo::neo4jName).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public List<String> namesRelationships() {
        return this.factory.metaData().persistentEntities().stream().filter(ci -> this.isRelationshipEntity(ci.getUnderlyingClass())).map(ClassInfo::neo4jName).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public boolean isRelationshipEntity(Class cls) {
        ClassInfo info = this.factory.metaData().classInfo(cls);
        return Objects.nonNull(info) && info.isRelationshipEntity();
    }

    public boolean isNodeEntity(Class cls) {
        ClassInfo info = this.factory.metaData().classInfo(cls);
        return Objects.nonNull(info) && !info.isRelationshipEntity();
    }
}

