/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import nu.mine.mosher.graph.datawebapp.Neo4jAuthenticatedSession;
import nu.mine.mosher.graph.datawebapp.store.Store;
import nu.mine.mosher.graph.datawebapp.util.Props;
import nu.mine.mosher.graph.datawebapp.view.PageHome;
import nu.mine.mosher.graph.datawebapp.view.PageLogin;
import nu.mine.mosher.graph.sample.imdb.Movie;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.ZonedDateTimeConverter;

public class GraphDataWebApp
extends AuthenticatedWebApplication {
    private String csvPackageNames;
    private Store store;
    private Props props;
    private String title;
    private String stylesheet;

    protected void init() {
        super.init();
        this.csvPackageNames = Optional.ofNullable(this.getInitParameter("packages")).orElse(Movie.class.getPackageName());
        this.store = new Store();
        this.props = new Props(this.store);
        this.title = Optional.ofNullable(this.getInitParameter("title")).orElse(this.csvPackageNames);
        this.stylesheet = Optional.ofNullable(this.getInitParameter("stylesheet")).orElse("");
    }

    protected void onDestroy() {
        System.out.println("onDestroy");
        this.store.close();
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator loc = new ConverterLocator();
        loc.set(ZonedDateTime.class, (IConverter)new ZonedDateTimeConverter(){

            protected DateTimeFormatter getDateTimeFormatter() {
                return DateTimeFormatter.ISO_ZONED_DATE_TIME;
            }
        });
        return loc;
    }

    public Class<? extends WebPage> getHomePage() {
        return PageHome.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return PageLogin.class;
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return Neo4jAuthenticatedSession.class;
    }

    public Props props() {
        return this.props;
    }

    public Store store() {
        return this.store;
    }

    public String title() {
        return this.title;
    }

    public String stylesheet() {
        return this.stylesheet;
    }

    public String packages() {
        return this.csvPackageNames;
    }
}

