/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gnopt.compiler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnoptCompiler {
    public static final String METHOD_NAME_FOR_UNNAMED_ARGS = "__";
    private static final Logger LOG = LoggerFactory.getLogger(GnoptCompiler.class);
    private static final Map<String, Predicate<Method>> REQUIREMENTS = GnoptCompiler.reqs();
    private final Map<String, Method> mapNameToMethod = new HashMap<String, Method>();
    private boolean failure;

    public static GnoptCompiler compile(Class classProcessor) throws InvalidOptionProcessorException {
        GnoptCompiler compiler = new GnoptCompiler();
        compiler.comp(Objects.requireNonNull(classProcessor));
        if (compiler.failure()) {
            throw new InvalidOptionProcessorException();
        }
        return compiler;
    }

    public boolean failure() {
        return this.failure;
    }

    public Optional<Method> processor(String name) {
        return Optional.ofNullable(this.mapNameToMethod.get(name));
    }

    private GnoptCompiler() {
    }

    private void comp(Class classProcessor) {
        LOG.trace("====> Compiling option-processor {}", (Object)classProcessor);
        for (Method method : classProcessor.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || Modifier.isStatic(method.getModifiers())) {
                LOG.trace("----> Skipping, method=\"{}\"", (Object)method);
                continue;
            }
            LOG.trace("----> Checking, method=\"{}\"", (Object)method);
            this.useMethodIfValid(method);
        }
    }

    private void useMethodIfValid(Method method) {
        boolean badMethod = false;
        for (Map.Entry<String, Predicate<Method>> req : REQUIREMENTS.entrySet()) {
            if (req.getValue().test(method)) continue;
            LOG.error("Failure, requirement=\"{}\", method=\"{}\"", (Object)req.getKey(), (Object)method);
            badMethod = true;
        }
        if (badMethod) {
            this.failure = true;
        } else {
            this.mapNameToMethod.put(method.getName(), method);
        }
    }

    private static Map<String, Predicate<Method>> reqs() {
        HashMap<String, Predicate<Method>> reqs = new HashMap<String, Predicate<Method>>();
        reqs.put("return type must be void", m -> m.getReturnType().equals(Void.TYPE));
        reqs.put("must have one and only one Optional<String> argument", m -> m.getParameters().length == 1 && GnoptCompiler.isOptionalString(m.getParameters()[0]));
        reqs.put("cannot be abstract", m -> !Modifier.isAbstract(m.getModifiers()));
        return Collections.unmodifiableMap(reqs);
    }

    private static boolean isOptionalString(Parameter p) {
        Type typ = p.getParameterizedType();
        if (!(typ instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType ptyp = (ParameterizedType)typ;
        return ptyp.getRawType().equals(Optional.class) && ptyp.getActualTypeArguments()[0].equals(String.class);
    }

    public static final class InvalidOptionProcessorException
    extends RuntimeException {
    }
}

