/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gnopt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import nu.mine.mosher.gnopt.compiler.GnoptCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gnopt<OptProc> {
    public static final String OPT_PREFIX = "--";
    private static final Logger LOG = LoggerFactory.getLogger(Gnopt.class);
    private final GnoptCompiler compilerProcessor;
    private final OptProc instanceProcessor;
    private boolean optionProcessingIsEnabled = true;

    public static <OptProc> OptProc process(Class<OptProc> classProcessor, String ... args) throws InvalidOption {
        GnoptCompiler compilerProcessor = GnoptCompiler.compile(Objects.requireNonNull(classProcessor));
        OptProc instanceProcessor = Gnopt.instantiate(classProcessor);
        if (Objects.nonNull(args)) {
            new Gnopt<OptProc>(compilerProcessor, instanceProcessor).process(args);
        }
        return instanceProcessor;
    }

    private Gnopt(GnoptCompiler compilerProcessor, OptProc instanceProcessor) {
        this.compilerProcessor = Objects.requireNonNull(compilerProcessor);
        this.instanceProcessor = Objects.requireNonNull(instanceProcessor);
    }

    private void process(String[] args) throws InvalidOption {
        for (String arg : Objects.requireNonNull(args)) {
            this.processArg(Objects.toString(arg, ""));
        }
    }

    private void processArg(String arg) throws InvalidOption {
        LOG.trace("processing argument/option: {}", (Object)(Objects.requireNonNull(arg).isEmpty() ? "(empty argument string)" : arg));
        if (this.optionProcessingIsEnabled && arg.startsWith(OPT_PREFIX)) {
            String opt = arg.substring(OPT_PREFIX.length());
            if (opt.isEmpty()) {
                this.optionProcessingIsEnabled = false;
            } else {
                this.processOption(opt);
            }
        } else {
            this.processNonOption(arg);
        }
    }

    private void processOption(String keyEqualsValue) throws InvalidOption {
        new NameValue(keyEqualsValue.split("=", 2)).process();
    }

    private void processNonOption(String value) throws InvalidOption {
        new NameValue("__", value).process();
    }

    private void process(String name, Optional<String> value) throws InvalidOption {
        try {
            this.processor(name).invoke(this.instanceProcessor, value);
        }
        catch (InvalidOption passThrough) {
            throw passThrough;
        }
        catch (InvocationTargetException unwrap) {
            throw new InvalidOption(unwrap.getCause());
        }
        catch (Throwable wrap) {
            throw new InvalidOption(wrap);
        }
    }

    private Method processor(String name) throws InvalidOption {
        Optional<Method> method = this.compilerProcessor.processor(name);
        if (!method.isPresent()) {
            Gnopt.throwInvalid(name);
        }
        return method.get();
    }

    private static void throwInvalid(String name) throws InvalidOption {
        if (name.equals("__")) {
            Gnopt.throwInvalid(null, "no arguments are allowed");
        } else {
            Gnopt.throwInvalid(name, "invalid option");
        }
    }

    private static void throwInvalid(String name, String message) throws InvalidOption {
        Object display = Objects.isNull(name) ? "" : (name.trim().isEmpty() ? " (with no name)" : " \"" + name + "\"");
        throw new InvalidOption(message + (String)display);
    }

    private static <OptProc> OptProc instantiate(Class<OptProc> classProcessor) throws InvalidOption {
        try {
            return classProcessor.newInstance();
        }
        catch (Throwable wrap) {
            throw new InvalidOption(wrap);
        }
    }

    private class NameValue {
        private final String name;
        private final Optional<String> value;

        private NameValue(String name, String value) {
            this.name = name;
            this.value = Optional.of(value);
        }

        private NameValue(String[] r) throws InvalidOption {
            String[] r2 = Arrays.copyOf(r, 2);
            this.name = this.filterName(r2[0]);
            if (this.name.equals("__")) {
                Gnopt.throwInvalid(this.name);
            }
            this.value = Optional.ofNullable(r2[1]);
        }

        private String filterName(String name) {
            return name.replace('-', '_');
        }

        private void process() throws InvalidOption {
            Gnopt.this.process(this.name, this.value);
        }
    }

    public static class InvalidOption
    extends Exception {
        private InvalidOption(String message) {
            super(message);
        }

        private InvalidOption(Throwable cause) {
            super(cause);
        }
    }
}

