/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gnopt;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnoptCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(GnoptCompiler.class);
    public static final String METHOD_NAME_FOR_UNNAMED_ARGS = "__";

    public static <OptProc> Map<String, Method> compile(Class<OptProc> optProcClass) throws InvalidOptionProcessorException {
        Method[] methods;
        HashMap<String, Method> mapNameToMethod = new HashMap<String, Method>();
        boolean fail = false;
        LOG.trace("Compiling options from {}", optProcClass);
        HashSet<String> methodNamesEncountered = new HashSet<String>();
        for (Method method : methods = optProcClass.getMethods()) {
            String methodName = method.getName();
            if (method.getDeclaringClass().equals(Object.class)) {
                LOG.trace("\"{}\" method is from class java.lang.Object, skipping", (Object)methodName);
                continue;
            }
            if (methodNamesEncountered.contains(methodName)) {
                LOG.error("Duplicate method name \"{}\", found in {}", (Object)methodName, optProcClass);
                fail = true;
            } else {
                methodNamesEncountered.add(methodName);
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                LOG.error("Method \"{}\" returning non-void, found in {}", (Object)methodName, optProcClass);
                fail = true;
                continue;
            }
            Parameter[] methodParameters = method.getParameters();
            if (methodName.equals(METHOD_NAME_FOR_UNNAMED_ARGS)) {
                if (methodParameters.length != 1 || !methodParameters[0].getType().equals(String.class)) {
                    LOG.error("Argument processing method \"{}\" must have one and only one String argument, in {}", (Object)methodName, optProcClass);
                    fail = true;
                    continue;
                }
                LOG.info("\"{}\" special argument-processing method; will be called for non-option arguments", (Object)methodName);
                mapNameToMethod.put(methodName, method);
                continue;
            }
            if (1 < methodParameters.length) {
                LOG.error("Method \"{}\" has two or more arguments, in {}", (Object)methodName, optProcClass);
                fail = true;
                continue;
            }
            if (methodParameters.length == 0) {
                LOG.info("\"{}\" flag-processing method; will be called for an option that is a flag (no value will be allowed)", (Object)methodName);
                mapNameToMethod.put(methodName, method);
                continue;
            }
            Type typ = methodParameters[0].getParameterizedType();
            if (!(typ instanceof ParameterizedType && ((ParameterizedType)typ).getRawType().equals(Optional.class) && ((ParameterizedType)typ).getActualTypeArguments()[0].equals(String.class))) {
                LOG.error("Option processing method \"{}\" must have one and only one Optional<String> argument, in {}", (Object)methodName, optProcClass);
                fail = true;
                continue;
            }
            LOG.info("\"{}\" option-processing method; will be called for an option that allows a value", (Object)methodName);
            mapNameToMethod.put(methodName, method);
        }
        if (fail) {
            throw new InvalidOptionProcessorException();
        }
        return mapNameToMethod;
    }

    public static final class InvalidOptionProcessorException
    extends RuntimeException {
    }
}

