/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gnopt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import nu.mine.mosher.gnopt.GnoptCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Gnopt<OptProc> {
    private static final Logger LOG = LoggerFactory.getLogger(Gnopt.class);
    public static final String OPT_PREFIX = "--";
    private final Map<String, Method> processors;
    private final OptProc optProc;
    private boolean optionProcessingIsEnabled = true;

    private Gnopt(Map<String, Method> processors, OptProc optProc) {
        this.processors = processors;
        this.optProc = optProc;
    }

    public static <OptProc> OptProc process(Class<OptProc> optProcClass, String ... args) throws InvocationTargetException, IllegalAccessException, InstantiationException, InvalidOption {
        Map<String, Method> processor = GnoptCompiler.compile(optProcClass);
        OptProc optProc = optProcClass.newInstance();
        super.process(args);
        return optProc;
    }

    private void process(String[] args) throws InvocationTargetException, IllegalAccessException, InvalidOption {
        for (String arg : args) {
            this.processArg(arg);
        }
    }

    private void processArg(String arg) throws InvalidOption, IllegalAccessException, InvocationTargetException {
        LOG.trace("processing argument/option: {}", (Object)(arg.isEmpty() ? "(empty argument string)" : arg));
        if (this.optionProcessingIsEnabled && arg.startsWith(OPT_PREFIX)) {
            if (arg.equals(OPT_PREFIX)) {
                this.optionProcessingIsEnabled = false;
            } else {
                this.option(arg.substring(OPT_PREFIX.length()));
            }
        } else {
            this.nonoption(arg);
        }
    }

    private void option(String arg) throws InvalidOption, IllegalAccessException, InvocationTargetException {
        if (arg.contains("=")) {
            Method method;
            String[] parts = arg.split("=", 2);
            assert (parts.length == 2);
            String name = parts[0];
            String value = parts[1];
            if (name.equals("__")) {
                Gnopt.throwInvalid(name);
            }
            if ((method = this.processor(name)).getParameterCount() == 0) {
                Gnopt.throwInvalid(name, "a value is not allowed for option");
            } else {
                method.invoke(this.optProc, Optional.of(value));
            }
        } else {
            Method method;
            String name = arg;
            if (name.equals("__")) {
                Gnopt.throwInvalid(name);
            }
            if ((method = this.processor(name)).getParameterCount() == 0) {
                method.invoke(this.optProc, new Object[0]);
            } else {
                method.invoke(this.optProc, Optional.empty());
            }
        }
    }

    private void nonoption(String arg) throws InvalidOption, IllegalAccessException, InvocationTargetException {
        this.processor("__").invoke(this.optProc, arg);
    }

    private Method processor(String name) throws InvalidOption {
        if (!this.processors.containsKey(name)) {
            Gnopt.throwInvalid(name);
        }
        return this.processors.get(name);
    }

    private static void throwInvalid(String name) throws InvalidOption {
        if (name.equals("__")) {
            Gnopt.throwInvalid(null, "no arguments are allowed");
        } else {
            Gnopt.throwInvalid(name, "invalid option");
        }
    }

    private static void throwInvalid(String name, String message) throws InvalidOption {
        String display = Objects.isNull(name) ? "" : (name.trim().isEmpty() ? " (with no name)" : " \"" + name + "\"");
        throw new InvalidOption(message + display);
    }

    public static class InvalidOption
    extends Throwable {
        private InvalidOption(String message) {
            super(message);
        }
    }
}

