/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.text.Normalizer;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.UidGen;

public class GedcomLine
implements Comparable<GedcomLine> {
    private final int level;
    private final String id;
    private final String tagString;
    private final String value;
    private final String pointer;
    private final GedcomTag tag;

    GedcomLine(int level, String id, String tag, String value) {
        this.level = level;
        this.id = GedcomLine.getPointer(id);
        this.tagString = tag;
        String v = GedcomLine.getPointer(value);
        if (v.length() > 0) {
            this.pointer = v;
            this.value = "";
        } else {
            this.value = GedcomLine.replaceAts(value);
            this.pointer = "";
        }
        this.tag = this.parseTag();
    }

    private GedcomLine(String id, int level, String pointer, GedcomTag tag, String tagString, String value) {
        this.id = id;
        this.level = level;
        this.pointer = pointer;
        this.tag = tag;
        this.tagString = tagString;
        this.value = value;
    }

    private GedcomTag parseTag() {
        try {
            return GedcomTag.valueOf(this.tagString);
        }
        catch (IllegalArgumentException e) {
            return GedcomTag.UNKNOWN;
        }
    }

    private static String getPointer(String s) {
        if (s.contains("@@") || !s.startsWith("@") || !s.endsWith("@") || s.length() < 3) {
            return "";
        }
        String pointer = s.substring(1, s.length() - 1);
        if (pointer.indexOf(64) >= 0) {
            return "";
        }
        return pointer;
    }

    private static String replaceAts(String s) {
        return s.replaceAll("@@", "@");
    }

    private static String restoreAts(String s) {
        return s.replaceAll("@", "@@");
    }

    public GedcomLine replaceValue(String newValue) {
        return new GedcomLine(this.level, "@" + this.id + "@", this.tagString, newValue);
    }

    public GedcomLine replaceLink(String newId) {
        if (this.hasID()) {
            return this.replaceId(newId);
        }
        if (this.isPointer()) {
            return this.replacePointer(newId);
        }
        throw new IllegalStateException("GedcomLine does not have an ID or a Pointer: " + this.toString());
    }

    public GedcomLine replacePointer(String newPointerWithoutAts) {
        return new GedcomLine(this.level, "", this.tagString, "@" + newPointerWithoutAts + "@");
    }

    public GedcomLine replaceId(String newIdWithoutAts) {
        return new GedcomLine(this.level, "@" + newIdWithoutAts + "@", this.tagString, this.value);
    }

    public GedcomLine replacePointer(GedcomLine to) {
        return new GedcomLine(this.level, "", this.tagString, "@" + to.getID() + "@");
    }

    public GedcomLine createChild(GedcomTag newTag, String newValue) {
        return this.createChild(newTag.name(), newValue);
    }

    public GedcomLine createChild(String newTag, String newValue) {
        return new GedcomLine(this.level + 1, "", newTag, newValue);
    }

    public static GedcomLine createHeader() {
        return new GedcomLine(0, "", GedcomTag.HEAD.name(), "");
    }

    public static GedcomLine createTrailer() {
        return new GedcomLine(0, "", GedcomTag.TRLR.name(), "");
    }

    public static GedcomLine createEmpty(int level, GedcomTag tag) {
        return new GedcomLine(level, "", tag.name(), "");
    }

    public static GedcomLine createEmptyId(String idWithoutAts, GedcomTag tag) {
        return new GedcomLine(0, "@" + idWithoutAts + "@", tag.name(), "");
    }

    public static GedcomLine createEmptyUid(GedcomTag tag) {
        return GedcomLine.createEmptyId(UidGen.generate(), tag);
    }

    public static GedcomLine create(int level, GedcomTag tag, String valueWithDoubledAts) {
        return new GedcomLine(level, "", tag.name(), valueWithDoubledAts);
    }

    public static GedcomLine createId(String idWithoutAts, GedcomTag tag, String valueWithDoubledAts) {
        return new GedcomLine(0, "@" + idWithoutAts + "@", tag.name(), valueWithDoubledAts);
    }

    public static GedcomLine createUid(GedcomTag tag, String valueWithDoubledAts) {
        return GedcomLine.createId(UidGen.generate(), tag, valueWithDoubledAts);
    }

    public static GedcomLine createPointer(int level, GedcomTag tag, String ptrWithoutAts) {
        return new GedcomLine(level, "", tag.name(), "@" + ptrWithoutAts + "@");
    }

    public static GedcomLine createUser(int level, String tag, String valueWithDoubledAts) {
        return new GedcomLine(level, "", tag, valueWithDoubledAts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(Integer.toString(this.level)).append(" ");
        if (this.hasID()) {
            sb.append("@").append(this.id).append("@ ");
        }
        sb.append(this.tagString);
        if (this.isPointer() || this.value.length() > 0) {
            sb.append(" ");
        }
        if (this.isPointer()) {
            sb.append("@").append(this.pointer).append("@");
        } else {
            String v = this.value;
            if (!this.tag.equals((Object)GedcomTag.DATE)) {
                v = GedcomLine.restoreAts(v);
                v = Normalizer.normalize(v, Normalizer.Form.NFC);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public void dump(StringBuilder appendTo) {
        appendTo.append(this.level);
        appendTo.append(",");
        if (this.hasID()) {
            appendTo.append("id=");
            appendTo.append(this.id);
            appendTo.append(",");
        }
        appendTo.append("tag=");
        appendTo.append(this.tagString);
        appendTo.append(",");
        if (this.isPointer()) {
            appendTo.append("pointer=");
            appendTo.append(this.pointer);
        } else {
            appendTo.append("value=\"");
            GedcomLine.appendFilteredValue(this.value, appendTo);
            appendTo.append("\"");
        }
    }

    private static void appendFilteredValue(String value, StringBuilder appendTo) {
        appendTo.append(value.replaceAll("\n", "[NEWLINE]"));
    }

    public boolean hasID() {
        return this.id.length() > 0;
    }

    public boolean isPointer() {
        return this.pointer.length() > 0;
    }

    public boolean isLink() {
        return this.isPointer() || this.hasID();
    }

    public String getID() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public String getPointer() {
        return this.pointer;
    }

    public String getLink() {
        if (this.isPointer()) {
            return this.getPointer();
        }
        if (this.hasID()) {
            return this.getID();
        }
        throw new IllegalStateException("GedcomLine does not have an ID or a Pointer: " + this.toString());
    }

    public GedcomTag getTag() {
        return this.tag;
    }

    public String getTagString() {
        return this.tagString;
    }

    public String getValue() {
        return this.value;
    }

    GedcomLine contValue(String sContinuedLine) {
        return new GedcomLine(this.id, this.level, this.pointer, this.tag, this.tagString, this.value + "\n" + sContinuedLine);
    }

    GedcomLine concValue(String sConcatenatedLine) {
        return new GedcomLine(this.id, this.level, this.pointer, this.tag, this.tagString, this.value + sConcatenatedLine);
    }

    @Override
    public int compareTo(GedcomLine that) {
        int c = 0;
        if (c == 0) {
            c = this.tagString.compareTo(that.tagString);
        }
        if (c == 0) {
            c = this.value.compareTo(that.value);
        }
        return c;
    }
}

