/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Time
implements Comparable<Time> {
    public static final String ISO8601_RFC3339_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final long ms;
    private final transient String asString;
    private final transient int hash;

    public Time(Date date) {
        this(date.getTime());
    }

    private Time(long ms) {
        this.ms = ms;
        if (this.ms != 0L) {
            SimpleDateFormat fmtDateTime = new SimpleDateFormat(ISO8601_RFC3339_DATE_TIME_FORMAT);
            this.asString = fmtDateTime.format(new Date(this.ms));
        } else {
            this.asString = "";
        }
        this.hash = (int)(this.ms ^ this.ms >>> 32);
    }

    public Date asDate() {
        return new Date(this.ms);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Time)) {
            return false;
        }
        Time that = (Time)object;
        return this.ms == that.ms;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.asString;
    }

    @Override
    public int compareTo(Time that) {
        if (this.ms < that.ms) {
            return -1;
        }
        if (that.ms < this.ms) {
            return 1;
        }
        return 0;
    }

    public static Time readFromString(String sTime) throws ParseException {
        long ms = 0L;
        if (sTime.length() > 0) {
            String t = sTime;
            if (t.endsWith("Z")) {
                t = t.substring(0, t.length() - 1) + "+0000";
            }
            SimpleDateFormat fmtDateTime = new SimpleDateFormat(ISO8601_RFC3339_DATE_TIME_FORMAT);
            ms = fmtDateTime.parse(t).getTime();
        }
        return new Time(ms);
    }
}

