/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import nu.mine.mosher.logging.Jul;

public class TreeNode<T extends Comparable<T>>
implements Iterable<TreeNode<T>>,
Comparable<TreeNode<T>> {
    private T object;
    private TreeNode<T> parent;
    private final List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();

    public TreeNode() {
        this(null);
    }

    public TreeNode(T object) {
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public Iterator<TreeNode<T>> children() {
        return this.children.iterator();
    }

    public ListIterator<TreeNode<T>> childrenList() {
        return this.children.listIterator();
    }

    public TreeNode<T> getFirstChildOrNull() {
        return this.children().hasNext() ? this.children().next() : null;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public void addChild(TreeNode<T> child) {
        this.addChildBefore(child, null);
    }

    public void addChildBefore(TreeNode<T> child, TreeNode<T> before) {
        if (child.parent != null) {
            child.removeFromParent();
        }
        if (before == null) {
            this.children.add(child);
        } else {
            this.children.add(this.children.indexOf(before), child);
        }
        child.parent = this;
    }

    public void sortDeep() {
        this.children.forEach(TreeNode::sortDeep);
        Collections.sort(this.children);
    }

    public void sort(Comparator<TreeNode<T>> comparator) {
        Collections.sort(this.children, comparator);
    }

    @Override
    public int compareTo(TreeNode<T> that) {
        if (this.object == null && that.object == null) {
            return 0;
        }
        if (this.object == null) {
            return -1;
        }
        if (that.object == null) {
            return 1;
        }
        return this.object.compareTo(that.object);
    }

    public void removeChild(TreeNode<T> child) throws NotChild {
        if (child.parent != this) {
            throw new NotChild(this, child);
        }
        Iterator<TreeNode<T>> i = this.children();
        while (i.hasNext()) {
            TreeNode<T> childN = i.next();
            if (childN != child) continue;
            i.remove();
            child.parent = null;
        }
    }

    public void removeAllChildren() {
        Iterator<TreeNode<T>> i = this.children();
        while (i.hasNext()) {
            TreeNode<T> child = i.next();
            i.remove();
            child.parent = null;
        }
    }

    public TreeNode<T> parent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        try {
            this.parent.removeChild(this);
        }
        catch (NotChild e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.appendStringShallow(sb);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sb.toString();
    }

    public void appendStringDeep(Appendable appendTo) throws IOException {
        this.appendStringDeep(appendTo, false);
    }

    public void appendStringDeep(Appendable appendTo, boolean indent) throws IOException {
        this.appendStringDeep(appendTo, indent, 0);
    }

    private void appendStringDeep(Appendable appendTo, boolean indent, int level) throws IOException {
        if (indent) {
            for (int i = 0; i < level; ++i) {
                appendTo.append("    ");
            }
        }
        if (this.object != null) {
            String line = this.object.toString();
            if (line.endsWith(" ")) {
                Jul.log().warning("Line ends with whitespace; some systems may erroneously truncate it:");
                Jul.log().warning(line + "|");
            }
            appendTo.append(line);
            appendTo.append("\n");
        }
        for (TreeNode<T> child : this.children) {
            super.appendStringDeep(appendTo, indent, level + 1);
        }
    }

    public void appendStringShallow(Appendable appendTo) throws IOException {
        if (this.object != null) {
            appendTo.append(this.object.toString());
        }
    }

    @Override
    public Iterator<TreeNode<T>> iterator() {
        return this.children();
    }

    public void forAll(Consumer<TreeNode<T>> fn) {
        fn.accept(this);
        if (this.getChildCount() > 0) {
            this.forEach(c -> c.forAll(fn));
        }
    }

    public static class NotChild
    extends Exception {
        private NotChild(TreeNode<?> node, TreeNode<?> child) {
            super("given TreeNode (" + child + ") is not a child of this TreeNode (" + node + ")");
        }
    }
}

