/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.date;

import java.util.Date;
import nu.mine.mosher.gedcom.date.YMD;
import nu.mine.mosher.time.Time;

public class DateRange
implements Comparable<DateRange> {
    private final YMD earliest;
    private final YMD latest;
    private final transient int hash;
    private final transient Time approx;
    private final transient boolean exact;
    public static final DateRange UNKNOWN = new DateRange(null);

    public DateRange(YMD ymdExact) {
        if (ymdExact != null) {
            this.earliest = this.latest = ymdExact;
            this.exact = true;
        } else {
            this.earliest = YMD.getMinimum();
            this.latest = YMD.getMaximum();
            this.exact = false;
        }
        this.approx = this.calcApprox();
        this.hash = this.calcHash();
    }

    public DateRange(YMD earliest, YMD latest) throws DatesOutOfOrder {
        this.earliest = earliest != null ? earliest : YMD.getMinimum();
        this.latest = latest != null ? latest : YMD.getMaximum();
        if (this.latest.compareTo(this.earliest) < 0) {
            throw new DatesOutOfOrder(this.earliest, this.latest);
        }
        this.approx = this.calcApprox();
        this.hash = this.calcHash();
        this.exact = this.earliest.equals(this.latest);
    }

    public YMD getEarliest() {
        return this.earliest;
    }

    public YMD getLatest() {
        return this.latest;
    }

    public boolean isExact() {
        return this.exact;
    }

    public Time getApproxDay() {
        return this.approx;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateRange)) {
            return false;
        }
        DateRange that = (DateRange)object;
        return this.earliest.equals(that.earliest) && this.latest.equals(that.latest);
    }

    public int hashCode() {
        return this.hash;
    }

    public String getTabularString() {
        StringBuilder sb = new StringBuilder();
        if (this.isExact()) {
            sb.append(this.earliest.getTabularString());
        } else if (this.equals(UNKNOWN)) {
            sb.append("?");
        } else {
            sb.append(this.earliest.getTabularString());
            sb.append("~");
            sb.append(this.latest.getTabularString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isExact()) {
            sb.append(this.earliest.toString());
        } else if (this.equals(UNKNOWN)) {
            sb.append("[unknown]");
        } else {
            sb.append(this.earliest.toString());
            sb.append("?");
            sb.append(this.latest.toString());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(DateRange that) {
        return this.approx.compareTo(that.approx);
    }

    private Time calcApprox() {
        if (this.earliest.equals(YMD.getMinimum()) && this.latest.equals(YMD.getMaximum())) {
            return new Time(new Date(0L));
        }
        if (this.earliest.equals(YMD.getMinimum())) {
            return this.latest.getApproxTime();
        }
        if (this.latest.equals(YMD.getMaximum())) {
            return this.earliest.getApproxTime();
        }
        if (this.exact) {
            return this.earliest.getApproxTime();
        }
        return new Time(new Date((this.earliest.getApproxTime().asDate().getTime() + this.latest.getApproxTime().asDate().getTime()) / 2L));
    }

    private int calcHash() {
        int h = 17;
        h *= 37;
        h += this.earliest.hashCode();
        h *= 37;
        return h += this.latest.hashCode();
    }

    public static class DatesOutOfOrder
    extends Exception {
        private DatesOutOfOrder(YMD earliestGreater, YMD latestLesser) {
            super("Latest date (" + latestLesser + ") is less than earliest date (" + earliestGreater + ").");
        }
    }
}

