/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nu.mine.mosher.collection.TreeNode;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.GedcomTree;
import nu.mine.mosher.logging.Jul;

public class GedcomMinimal {
    private static final String SUMB_ID = "M0";

    public static GedcomTree minimal(Charset charsetForce) {
        GedcomTree tree = new GedcomTree();
        TreeNode<GedcomLine> head = new TreeNode<GedcomLine>(GedcomLine.createHeader());
        tree.getRoot().addChild(head);
        head.addChild(new TreeNode<GedcomLine>(GedcomLine.createEmpty(1, GedcomTag.CHAR)));
        tree.setCharset(Charset.forName("UTF-8"));
        TreeNode<GedcomLine> gedc = new TreeNode<GedcomLine>(GedcomLine.createEmpty(1, GedcomTag.GEDC));
        head.addChild(gedc);
        gedc.addChild(new TreeNode<GedcomLine>(GedcomLine.create(2, GedcomTag.VERS, "5.5.1")));
        gedc.addChild(new TreeNode<GedcomLine>(GedcomLine.create(2, GedcomTag.FORM, "LINEAGE-LINKED")));
        head.addChild(new TreeNode<GedcomLine>(GedcomLine.create(1, GedcomTag.SOUR, "MINIMAL")));
        head.addChild(new TreeNode<GedcomLine>(GedcomLine.createPointer(1, GedcomTag.SUBM, SUMB_ID)));
        TreeNode<GedcomLine> subm = new TreeNode<GedcomLine>(GedcomLine.createEmptyId(SUMB_ID, GedcomTag.SUBM));
        tree.getRoot().addChild(subm);
        subm.addChild(new TreeNode<GedcomLine>(GedcomLine.create(1, GedcomTag.NAME, "MINIMAL")));
        tree.getRoot().addChild(new TreeNode<GedcomLine>(GedcomLine.createTrailer()));
        if (charsetForce == null) {
            charsetForce = StandardCharsets.UTF_8;
        } else {
            Jul.log().info("Forcing input character encoding to " + charsetForce.name());
        }
        tree.setCharset(charsetForce);
        return tree;
    }
}

