/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Jul {
    private static final Level LEVEL_DEFAULT = Level.WARNING;
    private static final String FORMAT_LOG = "%1$s [%2$-7s] %3$s%n%4$s";
    private static final String FORMAT_TS = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Logger logger = Logger.getLogger("");
    private static boolean initialized;

    private Jul() {
        throw new IllegalStateException();
    }

    public static Logger log() {
        Jul.initialize();
        return logger;
    }

    public static void setLevel(Level v) {
        Jul.log();
        logger.setLevel(v);
        Jul.handlers().forEach(h -> h.setLevel(v));
    }

    public static void verbose(boolean v) {
        Jul.setLevel(v ? Level.ALL : LEVEL_DEFAULT);
    }

    public static void thrown(Throwable thrown) {
        Jul.log().log(Level.SEVERE, thrown.toString(), thrown);
    }

    private static List<Handler> handlers() {
        return Arrays.asList(logger.getHandlers());
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        Jul.handlers().forEach(x$0 -> Formatter.adorn(x$0));
        Jul.verbose(false);
    }

    private static class Formatter
    extends java.util.logging.Formatter {
        private Formatter() {
        }

        private static void adorn(Handler h) {
            h.setFormatter(new Formatter());
        }

        @Override
        public String format(LogRecord r) {
            return String.format(Jul.FORMAT_LOG, this.ts(r.getMillis()), r.getLevel(), r.getMessage(), this.thr(r.getThrown()));
        }

        private String ts(long millis) {
            SimpleDateFormat df = new SimpleDateFormat(Jul.FORMAT_TS);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return df.format(new Date(millis));
        }

        private String thr(Throwable t) {
            StringWriter sw = new StringWriter();
            if (t != null) {
                t.printStackTrace(new PrintWriter((Writer)sw, true));
            }
            return sw.toString();
        }
    }
}

