/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.net.URI;
import java.net.URISyntaxException;

public class MultimediaReference {
    private final String s;
    private final URI uri;

    public MultimediaReference(String reference) {
        this.s = reference;
        this.uri = MultimediaReference.tryToParseAsUri(reference);
    }

    private static URI tryToParseAsUri(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String get() {
        return this.s;
    }

    public boolean wasUri() {
        return this.uri != null;
    }

    public URI asUri() {
        if (this.uri == null) {
            throw new UnsupportedOperationException("Multimedia reference could not be converted to a URI: " + this);
        }
        return this.uri;
    }

    public boolean equals(Object object) {
        return this.s.equals(object);
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public String toString() {
        return this.s;
    }
}

