/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.date;

import java.util.Date;
import java.util.GregorianCalendar;
import nu.mine.mosher.time.Time;

public class YMD
implements Comparable<YMD> {
    private final int year;
    private final int month;
    private final int day;
    private final boolean julian;
    private final boolean circa;
    private final transient int hash;
    private final transient Time approx;

    public YMD(int year) {
        this(year, 0);
    }

    public YMD(int year, int month) {
        this(year, month, 0, false, false);
    }

    public YMD(int year, int month, int day) {
        this(year, month, day, false, false);
    }

    public YMD(int year, int month, int day, boolean circa) {
        this(year, month, day, circa, false);
    }

    public YMD(int year, int month, int day, boolean circa, boolean julian) {
        this.year = year;
        if (this.year <= -10000 || this.year == 0 || 10000 <= this.year) {
            throw new IllegalStateException("Invalid year: " + this.year);
        }
        this.month = month;
        if (this.month < 0 || 12 < this.month) {
            throw new IllegalStateException("Invalid month: " + this.month);
        }
        this.day = day;
        if (this.day < 0 || 31 < this.day) {
            throw new IllegalStateException("Invalid day: " + this.day);
        }
        this.circa = circa;
        this.julian = julian;
        this.approx = this.calcApprox();
        this.hash = this.calcHash();
    }

    public YMD(Time time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.setTime(time.asDate());
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
        this.circa = false;
        this.julian = false;
        this.approx = this.calcApprox();
        this.hash = this.calcHash();
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public boolean isJulian() {
        return this.julian;
    }

    public boolean isCirca() {
        return this.circa;
    }

    public Time getExactTime() {
        if (!this.isExact()) {
            throw new IllegalStateException();
        }
        return this.approx;
    }

    public Time getApproxTime() {
        return this.approx;
    }

    public boolean isExact() {
        return YMD.valid(this.month) && YMD.valid(this.day) && !this.circa;
    }

    public static YMD getMinimum() {
        return new YMD(-9999, 1, 1);
    }

    public static YMD getMaximum() {
        return new YMD(9999, 12, 31);
    }

    public boolean equals(Object object) {
        if (!(object instanceof YMD)) {
            return false;
        }
        YMD that = (YMD)object;
        return this.year == that.year && this.month == that.month && this.day == that.day;
    }

    public int hashCode() {
        return this.hash;
    }

    public String getTabularString() {
        if (this.year == 9999 || this.year == -9999) {
            return "XXXX-XX-XX";
        }
        StringBuilder sb = new StringBuilder();
        if (this.year < 0) {
            sb.append('\u2212');
        }
        sb.append(String.format("%04d", Math.abs(this.year)));
        if (this.month > 0) {
            sb.append(String.format("-%02d", this.month));
        } else {
            sb.append("-XX");
        }
        if (this.day > 0) {
            sb.append(String.format("-%02d", this.day));
        } else {
            sb.append("-XX");
        }
        if (this.circa) {
            sb.append("~");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.circa) {
            sb.append("c. ");
        }
        if (this.year == 9999 || this.year == -9999) {
            if (this.equals(YMD.getMaximum())) {
                return "[after]";
            }
            if (this.equals(YMD.getMinimum())) {
                return "[before]";
            }
        }
        if (this.year < 0) {
            sb.append('-');
        }
        sb.append(String.format("%04d", Math.abs(this.year)));
        if (this.month > 0) {
            sb.append(String.format("-%02d", this.month));
            if (this.day > 0) {
                sb.append(String.format("-%02d", this.day));
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(YMD that) {
        return this.approx.compareTo(that.approx);
    }

    private static boolean valid(int i) {
        return i != 0;
    }

    private Time calcApprox() {
        int m = this.month;
        int d = this.day;
        if (m == 0 && d == 0) {
            m = 7;
            d = 3;
        } else if (d == 0) {
            d = 15;
        }
        return YMD.createTime(this.year, m, d);
    }

    private static Time createTime(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.set(year, month - 1, day, 12, 0, 0);
        cal.set(14, 0);
        return new Time(cal.getTime());
    }

    private int calcHash() {
        return this.approx.hashCode();
    }
}

