/* GedcomDateValueParser.java */
/* Generated By:JavaCC: Do not edit this line. GedcomDateValueParser.java */
package nu.mine.mosher.gedcom.date.parser;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import nu.mine.mosher.gedcom.date.YMD;
import nu.mine.mosher.gedcom.date.DateRange;
import nu.mine.mosher.gedcom.date.DatePeriod;
@ SuppressWarnings("all") public class GedcomDateValueParser implements GedcomDateValueParserConstants {
  public DatePeriod parse() throws ParseException {
    try {
      return DateValue();
    } catch (final ParseException e) {
      throw e;
    } catch (final Throwable w) {
      final ParseException e = new ParseException();
      e.initCause(w);
      throw e;
    }
  }

  private static YMD julianToGregorian(final YMD ymdJulian) {
    final GregorianCalendar J = new GregorianCalendar();
    J.setGregorianChange(new Date(Long.MAX_VALUE));
    J.set(ymdJulian.getYear(), ymdJulian.getMonth() - 1, ymdJulian.getDay());

    final Date date = J.getTime();

    final GregorianCalendar G = new GregorianCalendar();
    G.setGregorianChange(new Date(Long.MIN_VALUE));
    G.setTime(date);
    return new YMD(G.get(Calendar.YEAR), G.get(Calendar.MONTH) + 1, G.get(Calendar.DAY_OF_MONTH), false, true);
  }

  final public DatePeriod DateValue() throws ParseException, DateRange.DatesOutOfOrder {DatePeriod d;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTERPRETED:{
      d = DateInterp();
      break;
      }
    case FROM:
    case TO:{
      d = DatePeriod();
      break;
      }
    case BEFORE:
    case AFTER:
    case BETWEEN:{
      d = DateRange();
      break;
      }
    case ABOUT:
    case CALCULATED:
    case ESTIMATED:{
      d = DateApprox();
      break;
      }
    case JAN:
    case FEB:
    case MAR:
    case APR:
    case MAY:
    case JUN:
    case JUL:
    case AUG:
    case SEP:
    case OCT:
    case NOV:
    case DEC:
    case NUMBER:
    case 33:{
      d = DateSingle();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(0);
{if ("" != null) return d;}
    throw new Error("Missing return statement in function");
  }

  final public DatePeriod DateInterp() throws ParseException, DateRange.DatesOutOfOrder {DatePeriod d;
    jj_consume_token(INTERPRETED);
    S();
    d = DateSingle();
    S();
    DatePhrase();
{if ("" != null) return d;}
    throw new Error("Missing return statement in function");
  }

  final public String DatePhrase() throws ParseException {Token text;
    text = jj_consume_token(RAWTEXT);
{if ("" != null) return text.image;}
    throw new Error("Missing return statement in function");
  }

  final public DatePeriod DatePeriod() throws ParseException, DateRange.DatesOutOfOrder {YMD fromDate = null; YMD toDate = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
      S();
      fromDate = Date();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SPACES:{
        S();
        jj_consume_token(TO);
        S();
        toDate = Date();
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      break;
      }
    case TO:{
      jj_consume_token(TO);
      S();
      toDate = Date();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new DatePeriod(new DateRange(fromDate, fromDate), new DateRange(toDate, toDate));}
    throw new Error("Missing return statement in function");
  }

  final public DatePeriod DateRange() throws ParseException, DateRange.DatesOutOfOrder {YMD earliest = null; YMD latest = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AFTER:{
      jj_consume_token(AFTER);
      S();
      earliest = Date();
      break;
      }
    case BEFORE:{
      jj_consume_token(BEFORE);
      S();
      latest = Date();
      break;
      }
    case BETWEEN:{
      jj_consume_token(BETWEEN);
      S();
      earliest = Date();
      S();
      jj_consume_token(AND);
      S();
      latest = Date();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new DatePeriod(new DateRange(earliest, latest));}
    throw new Error("Missing return statement in function");
  }

  final public DatePeriod DateApprox() throws ParseException {YMD ymd;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ABOUT:{
      jj_consume_token(ABOUT);
      break;
      }
    case CALCULATED:{
      jj_consume_token(CALCULATED);
      break;
      }
    case ESTIMATED:{
      jj_consume_token(ESTIMATED);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    S();
    ymd = Date();
{if ("" != null) return new DatePeriod(new DateRange(new YMD(ymd.getYear(), ymd.getMonth(), ymd.getDay(), true, ymd.isJulian())));}
    throw new Error("Missing return statement in function");
  }

  final public DatePeriod DateSingle() throws ParseException {YMD ymd;
    ymd = Date();
{if ("" != null) return new DatePeriod(new DateRange(ymd));}
    throw new Error("Missing return statement in function");
  }

  final public YMD Date() throws ParseException {YMD ymd;
    if (jj_2_1(7)) {
      jj_consume_token(33);
      jj_consume_token(GREGORIAN);
      jj_consume_token(AT);
      OS();
      ymd = DateGregor();
    } else if (jj_2_2(7)) {
      jj_consume_token(33);
      jj_consume_token(JULIAN);
      jj_consume_token(AT);
      OS();
      ymd = DateJulian();
    } else if (jj_2_3(7)) {
      ymd = DateSlash();
    } else if (jj_2_4(7)) {
      ymd = DateGregor();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ymd;}
    throw new Error("Missing return statement in function");
  }

  final public YMD DateGregor() throws ParseException {YMD ymd; int e = 1;
    ymd = DateGregorRaw();
    if (jj_2_5(4)) {
      S();
      e = Epoch();
    } else {
      ;
    }
{if ("" != null) return new YMD(ymd.getYear() * e, ymd.getMonth(), ymd.getDay(), ymd.isCirca(), ymd.isJulian());}
    throw new Error("Missing return statement in function");
  }

  final public YMD DateJulian() throws ParseException {YMD ymd; int e = 1;
    ymd = DateJulianRaw();
    if (jj_2_6(2)) {
      S();
      e = Epoch();
    } else {
      ;
    }
{if ("" != null) return new YMD(ymd.getYear() * e, ymd.getMonth(), ymd.getDay(), ymd.isCirca(), ymd.isJulian());}
    throw new Error("Missing return statement in function");
  }

  final public YMD DateSlash() throws ParseException {int day = 0; int month = 0; int year = 0;
    if (jj_2_7(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        day = Day();
        S();
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        ;
      }
      month = MonthEngl();
      S();
    } else {
      ;
    }
    year = YearSlash();
{if ("" != null) return julianToGregorian(new YMD(year, month, day));}
    throw new Error("Missing return statement in function");
  }

  final public YMD DateGregorRaw() throws ParseException {int day = 0; int month = 0; int year = 0;
    if (jj_2_8(7)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        day = Day();
        S();
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      month = MonthEngl();
      S();
    } else {
      ;
    }
    year = Year();
{if ("" != null) return new YMD(year, month, day);}
    throw new Error("Missing return statement in function");
  }

  final public YMD DateJulianRaw() throws ParseException {int day = 0; int month = 0; int year = 0;
    if (jj_2_9(7)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        day = Day();
        S();
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        ;
      }
      month = MonthEngl();
      S();
    } else {
      ;
    }
    year = YearJulian();
{if ("" != null) return julianToGregorian(new YMD(year, month, day));}
    throw new Error("Missing return statement in function");
  }

  final public int YearJulian() throws ParseException {int year;
    if (jj_2_10(2)) {
      year = YearSlash();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        year = Year();
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return year;}
    throw new Error("Missing return statement in function");
  }

  final public int YearSlash() throws ParseException {int year;
    year = Year();
    jj_consume_token(SLASH);
    N();
{if ("" != null) return year + 1;}
    throw new Error("Missing return statement in function");
  }

  final public int Year() throws ParseException {int year;
    year = N();
if (year == 0) { {if (true) throw new ParseException("year cannot be zero.");} } {if ("" != null) return year;}
    throw new Error("Missing return statement in function");
  }

  final public int Day() throws ParseException {int day;
    day = N();
{if ("" != null) return day;}
    throw new Error("Missing return statement in function");
  }

  final public int N() throws ParseException {
    jj_consume_token(NUMBER);
{if ("" != null) return Integer.parseInt(this.token.image);}
    throw new Error("Missing return statement in function");
  }

  final public void S() throws ParseException {
    jj_consume_token(SPACES);
  }

  final public void OS() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SPACES:{
      jj_consume_token(SPACES);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
  }

  final public int Epoch() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BC:{
      jj_consume_token(BC);
{if ("" != null) return - 1;}
      break;
      }
    case AD:{
      jj_consume_token(AD);
{if ("" != null) return 1;}
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int MonthEngl() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case JAN:{
      jj_consume_token(JAN);
      break;
      }
    case FEB:{
      jj_consume_token(FEB);
      break;
      }
    case MAR:{
      jj_consume_token(MAR);
      break;
      }
    case APR:{
      jj_consume_token(APR);
      break;
      }
    case MAY:{
      jj_consume_token(MAY);
      break;
      }
    case JUN:{
      jj_consume_token(JUN);
      break;
      }
    case JUL:{
      jj_consume_token(JUL);
      break;
      }
    case AUG:{
      jj_consume_token(AUG);
      break;
      }
    case SEP:{
      jj_consume_token(SEP);
      break;
      }
    case OCT:{
      jj_consume_token(OCT);
      break;
      }
    case NOV:{
      jj_consume_token(NOV);
      break;
      }
    case DEC:{
      jj_consume_token(DEC);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return this.token.kind - MONTH_LOWER_LIMIT;}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_3R_17()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    }
    return false;
  }

  private boolean jj_3R_10()
 {
    if (jj_3R_16()) return true;
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_5()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) {
    jj_scanpos = xsp;
    if (jj_3R_14()) return true;
    }
    return false;
  }

  private boolean jj_3R_13()
 {
    if (jj_scan_token(BC)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(33)) return true;
    if (jj_scan_token(GREGORIAN)) return true;
    if (jj_scan_token(AT)) return true;
    if (jj_3R_1()) return true;
    if (jj_3R_2()) return true;
    return false;
  }

  private boolean jj_3R_1()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(33)) return true;
    if (jj_scan_token(JULIAN)) return true;
    if (jj_scan_token(AT)) return true;
    if (jj_3R_1()) return true;
    if (jj_3R_3()) return true;
    return false;
  }

  private boolean jj_3R_9()
 {
    if (jj_3R_15()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_8()
 {
    if (jj_3R_15()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_2()) return true;
    return false;
  }

  private boolean jj_3R_6()
 {
    if (jj_3R_15()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_9()) jj_scanpos = xsp;
    if (jj_3R_7()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_8()) jj_scanpos = xsp;
    if (jj_3R_7()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) jj_scanpos = xsp;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_11()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) jj_scanpos = xsp;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(31)) return true;
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_6()) jj_scanpos = xsp;
    if (jj_3R_7()) return true;
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(31)) return true;
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3R_4()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_4()) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_scan_token(AD)) return true;
    return false;
  }

  private boolean jj_3R_3()
 {
    if (jj_3R_12()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_2()
 {
    if (jj_3R_11()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_10()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public GedcomDateValueParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[12];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x10fff7be,0x80000000,0x6,0x38,0x380,0x10000000,0x10000000,0x10000000,0x10000000,0x80000000,0xc000000,0xfff000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public GedcomDateValueParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public GedcomDateValueParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new GedcomDateValueParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public GedcomDateValueParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new GedcomDateValueParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new GedcomDateValueParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public GedcomDateValueParser(GedcomDateValueParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(GedcomDateValueParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 12; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[34];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 12; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 34; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
