/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nu.mine.mosher.gedcom.model.Event;
import nu.mine.mosher.gedcom.model.ParentChildRelation;
import nu.mine.mosher.gedcom.model.Person;
import nu.mine.mosher.gedcom.model.Privatizable;

public class Partnership
implements Comparable<Partnership>,
Privatizable {
    private final ArrayList<Event> rEvent;
    private List<ParentChildRelation> rChild = new ArrayList<ParentChildRelation>();
    private final boolean isPrivate;
    private Person partner;

    public Partnership(ArrayList<Event> rEvent) {
        this(rEvent, false);
    }

    public Partnership(ArrayList<Event> rEvent, boolean isPrivate) {
        this.rEvent = new ArrayList<Event>(rEvent);
        this.isPrivate = isPrivate;
        Collections.sort(this.rEvent);
    }

    public void setPartner(Person partner) {
        this.partner = partner;
    }

    public Person getPartner() {
        return this.partner;
    }

    public ArrayList<Event> getEvents() {
        return this.rEvent;
    }

    @Deprecated
    public ArrayList<Person> getChildren() {
        return new ArrayList<Person>(this.rChild.stream().map(ParentChildRelation::getOther).collect(Collectors.toList()));
    }

    public ArrayList<ParentChildRelation> getChildRelations() {
        return new ArrayList<ParentChildRelation>(this.rChild);
    }

    @Deprecated
    public void addChildren(Collection<Person> rChildToAdd) {
        this.rChild.addAll(rChildToAdd.stream().map(ParentChildRelation::of).collect(Collectors.toList()));
        Collections.sort(this.rChild);
    }

    public void addChildRelations(Collection<ParentChildRelation> newFullSet) {
        this.rChild = new ArrayList<ParentChildRelation>(newFullSet);
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public int compareTo(Partnership that) {
        if (this.rEvent.isEmpty() && that.rEvent.isEmpty()) {
            return 0;
        }
        if (!this.rEvent.isEmpty() && that.rEvent.isEmpty()) {
            return -1;
        }
        if (this.rEvent.isEmpty() && !that.rEvent.isEmpty()) {
            return 1;
        }
        return this.rEvent.get(0).compareTo(that.rEvent.get(0));
    }
}

