/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.universalchardet.UnicodeBOMInputStream;
import org.mozilla.universalchardet.UniversalDetector;

public class GedcomEncodingDetector {
    private static final Logger log = Logger.getLogger("");
    private final BufferedInputStream gedcom;
    private static final int START = 0;
    private static final int IN_HEAD = 1;
    private static final int OUT_HEAD = 2;
    private static final Pattern HEAD_LINE = Pattern.compile("0\\s+HEAD.*");
    private static final Pattern CHAR_LINE = Pattern.compile("1\\s+CHAR\\s+(.*)");
    private static final Pattern REC0_LINE = Pattern.compile("0\\s+.*");
    private static final Map<String, String> mapChar;

    public GedcomEncodingDetector(BufferedInputStream gedcom) {
        this.gedcom = gedcom;
    }

    public Charset detect() throws IOException {
        Optional<Charset> charsetDetected = GedcomEncodingDetector.detectCharsetDefault(this.gedcom);
        if (charsetDetected.isPresent()) {
            log.info(String.format("First guess at character encoding: %s", charsetDetected.get().displayName()));
        } else {
            log.info("First guess at character encoding failed.");
            log.info(String.format("First guess at character encoding defaulting to: %s", Charset.defaultCharset().displayName()));
        }
        Optional<Charset> charsetDeclared = GedcomEncodingDetector.detectCharsetDeclared(this.gedcom, charsetDetected.orElse(Charset.defaultCharset()));
        if (charsetDeclared.isPresent()) {
            log.info(String.format("Found declared character encoding: %s", charsetDeclared.get().displayName()));
        }
        Charset charsetResult = charsetDetected.isPresent() && charsetDeclared.isPresent() ? this.resolveConflictingCharsets(charsetDetected.get(), charsetDeclared.get()) : (charsetDetected.isPresent() ? charsetDetected.get() : (charsetDeclared.isPresent() ? charsetDeclared.get() : Charset.defaultCharset()));
        log.info(String.format("Will use character encoding: %s", charsetResult.displayName()));
        return charsetResult;
    }

    private Charset resolveConflictingCharsets(Charset detected, Charset declared) {
        if (detected.equals(declared)) {
            return detected;
        }
        if (this.isDetectionReliable(detected)) {
            return detected;
        }
        return declared;
    }

    private boolean isDetectionReliable(Charset detected) {
        return detected.name().contains("UTF");
    }

    private static Optional<Charset> detectCharsetDefault(BufferedInputStream gedcomStream) throws IOException {
        int cBytesToCheck = 65536;
        gedcomStream.mark(65536);
        try {
            Optional<Charset> optional = GedcomEncodingDetector.tryDetectCharsetDefault(gedcomStream, 65536);
            return optional;
        }
        finally {
            gedcomStream.reset();
        }
    }

    private static Optional<Charset> tryDetectCharsetDefault(BufferedInputStream gedcomStream, int cBytesToCheck) throws IOException {
        UniversalDetector detector = new UniversalDetector();
        int cBufferSize = 4096;
        byte[] buf = new byte[4096];
        boolean first = true;
        int sane = cBytesToCheck / 4096;
        int nread = gedcomStream.read(buf);
        while (nread > 0 && --sane > 0) {
            Optional<Charset> prescreened;
            if (first && nread >= 4 && (prescreened = GedcomEncodingDetector.prescreen(buf)).isPresent()) {
                return prescreened;
            }
            first = false;
            detector.handleData(buf, 0, nread);
            nread = gedcomStream.read(buf);
        }
        detector.dataEnd();
        return GedcomEncodingDetector.charsetForName(detector);
    }

    private static Optional<Charset> prescreen(byte[] b) {
        if (b[0] == 48 && b[1] == 0 && b[2] == 32 && b[3] == 0) {
            return Optional.of(StandardCharsets.UTF_16LE);
        }
        if (b[0] == 0 && b[1] == 48 && b[2] == 0 && b[3] == 32) {
            return Optional.of(StandardCharsets.UTF_16BE);
        }
        return Optional.empty();
    }

    private static Optional<Charset> charsetForName(UniversalDetector detector) {
        String c = detector.getDetectedCharset();
        if (Objects.isNull(c)) {
            log.info("Character detector returned null.");
            return Optional.empty();
        }
        if (c.isEmpty()) {
            log.info("Character detector returned empty string.");
            return Optional.empty();
        }
        try {
            return Optional.of(Charset.forName(c));
        }
        catch (Exception ignore) {
            log.log(Level.WARNING, String.format("Character detector returned invalid Charset name: %s", c), ignore);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Charset> detectCharsetDeclared(BufferedInputStream gedcomStream, Charset charsetBestGuess) throws IOException {
        int cBytesToCheck = 32768;
        gedcomStream.mark(32768);
        try {
            Optional<Charset> optional = GedcomEncodingDetector.tryDetectCharsetDeclared(gedcomStream, 32768, charsetBestGuess);
            return optional;
        }
        finally {
            gedcomStream.reset();
        }
    }

    private static Optional<Charset> tryDetectCharsetDeclared(BufferedInputStream gedcomStream, int cBytesToCheck, Charset charsetBestGuess) throws IOException {
        String headChar = GedcomEncodingDetector.interpretHeadChar(GedcomEncodingDetector.tryDetectCharsetNameDeclared(gedcomStream, cBytesToCheck, charsetBestGuess));
        if (headChar.isEmpty()) {
            log.warning("Did not recognize that value for CHAR.");
            return Optional.empty();
        }
        try {
            return Optional.of(Charset.forName(headChar));
        }
        catch (Exception ignore) {
            log.log(Level.WARNING, String.format("Invalid Charset name: %s", headChar), ignore);
            return Optional.empty();
        }
    }

    private static String tryDetectCharsetNameDeclared(BufferedInputStream gedcomStream, int cBytesToCheck, Charset charsetBestGuess) throws IOException {
        BufferedReader gedcomReader = GedcomEncodingDetector.createNiceLineReader(gedcomStream, charsetBestGuess);
        int sane = cBytesToCheck / 2;
        int state = 0;
        String line = gedcomReader.readLine();
        while (line != null && sane > 0) {
            sane -= line.length() + 2;
            line = line.trim();
            switch (state) {
                case 0: {
                    if (!HEAD_LINE.matcher(line).matches()) break;
                    log.fine("Found HEAD line. Good.");
                    state = 1;
                    break;
                }
                case 1: {
                    if (REC0_LINE.matcher(line).matches()) {
                        state = 2;
                        break;
                    }
                    Matcher matcher = CHAR_LINE.matcher(line);
                    if (!matcher.matches()) break;
                    String charsetNameDeclared = matcher.group(1).trim();
                    log.info(String.format("Found CHAR line with value: %s", charsetNameDeclared));
                    return charsetNameDeclared.toUpperCase();
                }
                case 2: {
                    log.warning("Could not find CHAR line.");
                    return "";
                }
            }
            line = gedcomReader.readLine();
        }
        log.warning("Could not find HEAD line.");
        return "";
    }

    private static BufferedReader createNiceLineReader(BufferedInputStream gedcomStream, Charset charsetBestGuess) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new UnicodeBOMInputStream((InputStream)gedcomStream), charsetBestGuess));
    }

    private static BufferedInputStream getStandardInput() {
        return new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    }

    private static String interpretHeadChar(String headChar) {
        return Objects.toString(mapChar.get(headChar), "");
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("IBMPC", "Cp437");
        m.put("IBM-PC", "Cp437");
        m.put("IBM", "Cp437");
        m.put("PC", "Cp437");
        m.put("OEM", "Cp437");
        m.put("MSDOS", "Cp850");
        m.put("MS-DOS", "Cp850");
        m.put("DOS", "Cp850");
        m.put("IBM DOS", "Cp850");
        m.put("ANSI", "windows-1252");
        m.put("WINDOWS", "windows-1252");
        m.put("WIN", "windows-1252");
        m.put("IBM WINDOWS", "windows-1252");
        m.put("IBM_WINDOWS", "windows-1252");
        m.put("ASCII", "windows-1252");
        m.put("CP1252", "windows-1252");
        m.put("ISO-8859-1", "windows-1252");
        m.put("ISO8859-1", "windows-1252");
        m.put("ISO-8859", "windows-1252");
        m.put("LATIN1", "windows-1252");
        m.put("MAC", "MacRoman");
        m.put("MACINTOSH", "MacRoman");
        m.put("UNICODE", "UTF-16");
        m.put("UTF-8", "UTF-8");
        m.put("ANSEL", "x-gedcom-ansel");
        mapChar = Collections.unmodifiableMap(m);
    }
}

