/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.text.BreakIterator;

public class Source {
    private final String ID;
    private final String author;
    private final String title;
    private final String publication;
    private final String text;
    private final String shortName;

    public Source(String ID, String author, String title, String publication, String text) {
        this.ID = ID;
        this.author = author;
        this.title = title;
        this.publication = publication;
        this.text = text;
        this.shortName = this.buildShortName();
    }

    public String getID() {
        return this.ID;
    }

    private String buildShortName() {
        if (this.title.length() == 0) {
            return this.title;
        }
        BreakIterator wordIter = BreakIterator.getWordInstance();
        wordIter.setText(this.title);
        int start = wordIter.first();
        StringBuilder sb = new StringBuilder(32);
        int iWord = 0;
        int end = wordIter.next();
        while (end != -1 && ++iWord < 15) {
            sb.append(this.title, start, end);
            start = end;
            end = wordIter.next();
        }
        return sb.toString();
    }

    public String getAuthor() {
        return this.author;
    }

    public String getPublication() {
        return this.publication;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }
}

