/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nu.mine.mosher.gedcom.date.DatePeriod;
import nu.mine.mosher.gedcom.date.DateRange;
import nu.mine.mosher.gedcom.date.YMD;
import nu.mine.mosher.gedcom.model.Event;
import nu.mine.mosher.gedcom.model.FamilyEvent;
import nu.mine.mosher.gedcom.model.ParentChildRelation;
import nu.mine.mosher.gedcom.model.Partnership;
import nu.mine.mosher.gedcom.model.Privatizable;
import nu.mine.mosher.time.Time;

public class Person
implements Comparable<Person>,
Privatizable {
    private static final Pattern patternName = Pattern.compile("(.*)/(.*)/(.*)");
    private final UUID uuid;
    private final String ID;
    private final String name;
    private final String nameSortable;
    private final String nameSortedDisplay;
    private final ArrayList<Event> rEvent;
    private final ArrayList<Partnership> rPartnership;
    private final boolean isPrivate;
    private Time birth = new Time(new Date(0L));
    private Time death = new Time(new Date(0L));
    private List<Time> rMarriage = new ArrayList<Time>();
    private List<Time> rDivorce = new ArrayList<Time>();
    private ArrayList<ParentChildRelation> fathers = new ArrayList();
    private ArrayList<ParentChildRelation> mothers = new ArrayList();

    public Person(String ID, String name, ArrayList<Event> rEvent, ArrayList<Partnership> partnership, boolean isPrivate, UUID uuid) {
        this.uuid = uuid == null ? UUID.randomUUID() : uuid;
        this.ID = ID;
        this.name = name;
        this.nameSortable = Person.buildNameForAlphaSort(name);
        this.nameSortedDisplay = Person.buildNameForAlphaDisplay(name);
        this.rEvent = rEvent;
        this.rPartnership = partnership;
        this.isPrivate = isPrivate;
        Collections.sort(this.rEvent);
        Collections.sort(this.rPartnership);
    }

    public void sortPartnerships() {
        Collections.sort(this.rPartnership);
    }

    public static String buildNameForAlphaSort(String name) {
        Matcher matcher = patternName.matcher(name);
        if (!matcher.matches()) {
            return name.trim().toUpperCase();
        }
        String givenName1 = matcher.group(1).trim();
        String surname = matcher.group(2).trim();
        String givenName2 = matcher.group(3).trim();
        return Person.buildAlphaName(Person.cleanseGivenNames(givenName1), Person.cleanseSurname(surname), Person.cleanseGivenNames(givenName2)).toUpperCase();
    }

    public static String buildNameForAlphaDisplay(String name) {
        Matcher matcher = patternName.matcher(name);
        if (!matcher.matches()) {
            return name;
        }
        String givenName1 = matcher.group(1).trim();
        String surname = matcher.group(2).trim();
        String givenName2 = matcher.group(3).trim();
        return Person.buildAlphaName(givenName1, surname, givenName2);
    }

    public static String buildAlphaName(String givenName1, String surname, String givenName2) {
        StringBuilder sb = new StringBuilder(32);
        Person.appendWord(sb, "", surname);
        Person.appendWord(sb, ", ", givenName1);
        Person.appendWord(sb, " ", givenName2);
        return sb.toString();
    }

    public static void appendWord(StringBuilder appendTo, String delim, String wordOrEmpty) {
        if (wordOrEmpty == null) {
            return;
        }
        String w = wordOrEmpty.trim();
        if (w.isEmpty()) {
            return;
        }
        if (appendTo.length() > 0) {
            appendTo.append(delim);
        }
        appendTo.append(w);
    }

    public static String cleanseGivenNames(String s) {
        return Person.cleanse(s, " ");
    }

    public static String cleanseSurname(String s) {
        return Person.cleanse(s, "\u00a0");
    }

    public static String cleanse(String s, String r) {
        return s.replaceAll("[^\\p{IsAlphabetic}\\p{IsWhite_Space}]", "").replaceAll("\\p{IsWhite_Space}+", r);
    }

    public void initKeyDates() {
        for (Event event : this.rEvent) {
            if (event.getDate() == null) continue;
            if (event.getType().equals("birth")) {
                this.birth = event.getDate().getStartDate().getApproxDay();
                continue;
            }
            if (!event.getType().equals("death")) continue;
            this.death = event.getDate().getStartDate().getApproxDay();
        }
        if (this.birth.asDate().getTime() == 0L) {
            this.birth = YMD.getMinimum().getApproxTime();
        }
        if (this.death.asDate().getTime() == 0L) {
            this.death = YMD.getMaximum().getApproxTime();
        }
        if (this.rPartnership.size() > 0) {
            for (Partnership par : this.rPartnership) {
                boolean mar = false;
                boolean div = false;
                for (Event event : par.getEvents()) {
                    if (event.getDate() == null) continue;
                    if (event.getType().equals("marriage")) {
                        this.rMarriage.add(event.getDate().getStartDate().getApproxDay());
                        mar = true;
                        continue;
                    }
                    if (!event.getType().equals("divorce")) continue;
                    this.rDivorce.add(event.getDate().getStartDate().getApproxDay());
                    div = true;
                }
                if (!mar && par.getChildRelations().size() > 0) {
                    Time birthChild = par.getChildRelations().get(0).getOther().getBirth();
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setGregorianChange(new Date(Long.MIN_VALUE));
                    cal.setTime(birthChild.asDate());
                    cal.add(1, -1);
                    this.rMarriage.add(new Time(cal.getTime()));
                    mar = true;
                }
                if (!mar) {
                    this.rMarriage.add(YMD.getMinimum().getApproxTime());
                    mar = true;
                }
                if (!div) {
                    this.rDivorce.add(this.death);
                    div = true;
                }
                assert (mar && div);
            }
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setGregorianChange(new Date(Long.MIN_VALUE));
            cal.setTime(this.birth.asDate());
            cal.add(1, 18);
            this.rMarriage.add(new Time(cal.getTime()));
            this.rDivorce.add(YMD.getMaximum().getApproxTime());
        }
    }

    public Time getBirth() {
        return this.birth;
    }

    public Time getDeath() {
        return this.death;
    }

    public String toString() {
        return this.name.replaceAll("/", "");
    }

    public String getNameSortable() {
        return this.nameSortable;
    }

    public String getNameSortedDisplay() {
        return this.nameSortedDisplay;
    }

    public String getClassedName() {
        Matcher matcher = patternName.matcher(this.name);
        if (!matcher.matches()) {
            return this.name;
        }
        return matcher.group(1) + "<span class=\"surname\">" + matcher.group(2) + "</span>" + matcher.group(3);
    }

    @Deprecated
    public void setFather(Person father) {
        this.addFather(ParentChildRelation.of(father));
    }

    public void addFather(ParentChildRelation relationFather) {
        this.fathers.add(relationFather);
    }

    @Deprecated
    public void setMother(Person mother) {
        this.addMother(ParentChildRelation.of(mother));
    }

    public void addMother(ParentChildRelation relationMother) {
        this.mothers.add(relationMother);
    }

    @Deprecated
    public void setPrivateParentage(boolean isPrivate) {
        if (!this.fathers.isEmpty()) {
            this.fathers.get(this.fathers.size() - 1).setPrivate(isPrivate);
        }
        if (!this.mothers.isEmpty()) {
            this.mothers.get(this.mothers.size() - 1).setPrivate(isPrivate);
        }
    }

    @Deprecated
    public boolean isPrivateParentage() {
        if (!this.fathers.isEmpty() && this.fathers.get(0).isPrivate()) {
            return true;
        }
        return !this.mothers.isEmpty() && this.mothers.get(0).isPrivate();
    }

    @Deprecated
    public Person getFather() {
        if (!this.fathers.isEmpty()) {
            return this.fathers.get(0).getOther();
        }
        return null;
    }

    public ArrayList<ParentChildRelation> getFathers() {
        return this.fathers;
    }

    @Deprecated
    public Person getMother() {
        if (!this.mothers.isEmpty()) {
            return this.mothers.get(0).getOther();
        }
        return null;
    }

    public ArrayList<ParentChildRelation> getMothers() {
        return this.mothers;
    }

    public ArrayList<Event> getEvents() {
        return this.rEvent;
    }

    public List<Event> getEventsWithDittoedPlaces() {
        return Person.shortenPlaces(this.dittoPlaces());
    }

    private static ArrayList<Event> shortenPlaces(ArrayList<Event> places) {
        ArrayList<Event> r = new ArrayList<Event>(places.size());
        HashMap<String, String> mapPlaceToShort = new HashMap<String, String>();
        HashMap<String, String> mapShortToPlace = new HashMap<String, String>();
        HashSet<String> dupsShort = new HashSet<String>();
        for (Event e : places) {
            String sh;
            String place = e.getPlace();
            if (place.length() <= 4 || dupsShort.contains(sh = Person.shortenPlace(place))) continue;
            if (mapShortToPlace.containsKey(sh) && !((String)mapShortToPlace.get(sh)).equals(place)) {
                mapPlaceToShort.remove(mapShortToPlace.get(sh));
                mapShortToPlace.remove(sh);
                dupsShort.add(sh);
                continue;
            }
            mapShortToPlace.put(sh, place);
            mapPlaceToShort.put(place, sh);
        }
        HashSet<String> seen = new HashSet<String>();
        for (Event e : places) {
            String place = e.getPlace();
            if (seen.contains(place) && mapPlaceToShort.containsKey(place)) {
                r.add(new Event(e.getType(), e.getDate(), (String)mapPlaceToShort.get(place), e.getNote(), e.getCitations(), e.isPrivate()));
                continue;
            }
            r.add(e);
            seen.add(place);
        }
        return r;
    }

    private static String shortenPlace(String place) {
        return place.split(",", 2)[0];
    }

    public ArrayList<Event> dittoPlaces() {
        ArrayList<Event> r = new ArrayList<Event>(this.rEvent.size());
        String placePrev = UUID.randomUUID().toString();
        for (Event e : this.rEvent) {
            String place;
            if (e.getPlace().equals(placePrev) && !e.getPlace().isEmpty()) {
                place = "\u00a0\u201d";
            } else {
                placePrev = place = e.getPlace();
            }
            r.add(new Event(e.getType(), e.getDate(), place, e.getNote(), e.getCitations(), e.isPrivate()));
        }
        return r;
    }

    public ArrayList<Event> getEventsWithin(DatePeriod period) {
        ArrayList<Event> rWithin = new ArrayList<Event>();
        for (Event event : this.rEvent) {
            if (event.getDate() == null || !event.getDate().overlaps(period)) continue;
            rWithin.add(event);
        }
        return rWithin;
    }

    public ArrayList<Partnership> getPartnerships() {
        return this.rPartnership;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getID() {
        return this.ID;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public int compareTo(Person that) {
        if (this.rEvent.isEmpty() && that.rEvent.isEmpty()) {
            return 0;
        }
        if (!this.rEvent.isEmpty() && that.rEvent.isEmpty()) {
            return -1;
        }
        if (this.rEvent.isEmpty() && !that.rEvent.isEmpty()) {
            return 1;
        }
        return this.rEvent.get(0).compareTo(that.rEvent.get(0));
    }

    public ArrayList<FamilyEvent> getFamilyEvents() {
        ArrayList<FamilyEvent> rEventRet = new ArrayList<FamilyEvent>();
        this.getEventsOfSelf(rEventRet);
        this.getEventsOfPartnership(rEventRet);
        this.getEventsOfFather(rEventRet);
        this.getEventsOfMother(rEventRet);
        this.getEventsOfSpouses(rEventRet);
        this.getEventsOfChildren(rEventRet);
        Collections.sort(rEventRet);
        return rEventRet;
    }

    private void getEventsOfSelf(List<FamilyEvent> rEventRet) {
        rEventRet.addAll(this.getEvents().stream().map(event -> new FamilyEvent(this, (Event)event, "self")).collect(Collectors.toList()));
    }

    private void getEventsOfPartnership(List<FamilyEvent> rEventRet) {
        for (Partnership part : this.rPartnership) {
            rEventRet.addAll(part.getEvents().stream().map(event -> new FamilyEvent(part.getPartner(), (Event)event, "spouse")).collect(Collectors.toList()));
        }
    }

    private void getEventsOfFather(List<FamilyEvent> rEventRet) {
        this.fathers.forEach(p -> this.getEventsOfParent(p.getOther(), "father", rEventRet));
    }

    private void getEventsOfMother(List<FamilyEvent> rEventRet) {
        this.mothers.forEach(p -> this.getEventsOfParent(p.getOther(), "mother", rEventRet));
    }

    private void getEventsOfParent(Person parent, String relation, List<FamilyEvent> rEventRet) {
        if (parent != null) {
            rEventRet.addAll(parent.getEventsWithin(this.getChildhood()).stream().map(event -> new FamilyEvent(parent, (Event)event, relation)).collect(Collectors.toList()));
        }
    }

    private void getEventsOfSpouses(List<FamilyEvent> rEventRet) {
        int p = 0;
        for (Partnership partnership : this.rPartnership) {
            Person partner = partnership.getPartner();
            if (partner != null) {
                rEventRet.addAll(partner.getEventsWithin(this.getPartnerhood(p)).stream().map(event -> new FamilyEvent(partnership.getPartner(), (Event)event, "spouse")).collect(Collectors.toList()));
            }
            ++p;
        }
    }

    private void getEventsOfChildren(List<FamilyEvent> rEventRet) {
        for (Partnership partnership : this.rPartnership) {
            for (ParentChildRelation rel : partnership.getChildRelations()) {
                Person child = rel.getOther();
                rEventRet.addAll(child.getEventsWithin(child.getChildhood()).stream().map(event -> new FamilyEvent(child, (Event)event, "child")).collect(Collectors.toList()));
            }
        }
    }

    private DatePeriod getChildhood() {
        return new DatePeriod(new DateRange(new YMD(this.birth)), new DateRange(new YMD(this.rMarriage.get(0))));
    }

    private DatePeriod getPartnerhood(int p) {
        return new DatePeriod(new DateRange(new YMD(this.rMarriage.get(p))), new DateRange(new YMD(this.rDivorce.get(p))));
    }
}

