/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.io.StringReader;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import nu.mine.mosher.collection.TreeNode;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.GedcomTree;
import nu.mine.mosher.gedcom.date.DatePeriod;
import nu.mine.mosher.gedcom.date.parser.GedcomDateValueParser;
import nu.mine.mosher.gedcom.model.AncestryPersona;
import nu.mine.mosher.gedcom.model.Citation;
import nu.mine.mosher.gedcom.model.Event;
import nu.mine.mosher.gedcom.model.EventNames;
import nu.mine.mosher.gedcom.model.MultimediaReference;
import nu.mine.mosher.gedcom.model.ParentChildRelation;
import nu.mine.mosher.gedcom.model.Partnership;
import nu.mine.mosher.gedcom.model.Person;
import nu.mine.mosher.gedcom.model.Source;
import nu.mine.mosher.logging.Jul;
import nu.mine.mosher.time.Time;

public class Loader {
    private final GedcomTree gedcom;
    private final String name;
    private final Map<UUID, Person> mapUUIDtoPerson = new HashMap<UUID, Person>();
    private final Map<TreeNode<GedcomLine>, Person> mapNodeToPerson = new HashMap<TreeNode<GedcomLine>, Person>();
    private final Map<TreeNode<GedcomLine>, Partnerships> mapNodeToPartnerships = new HashMap<TreeNode<GedcomLine>, Partnerships>();
    private final Map<TreeNode<GedcomLine>, Event> mapNodeToEvent = new HashMap<TreeNode<GedcomLine>, Event>();
    private final Map<TreeNode<GedcomLine>, Source> mapNodeToSource = new HashMap<TreeNode<GedcomLine>, Source>();
    private Person first;
    private final List<Person> people = new ArrayList<Person>(256);
    private final Collator sorter;
    private String description = "";
    private String copyright = "";

    public Loader(GedcomTree gedcom, String filename) {
        this.gedcom = gedcom;
        this.name = filename;
        this.sorter = this.sorter();
    }

    public void parse() {
        GedcomTag tagTop;
        GedcomLine lineTop;
        ArrayList<TreeNode<GedcomLine>> rNodeTop = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(this.gedcom.getRoot(), rNodeTop);
        String root = "";
        for (TreeNode treeNode : rNodeTop) {
            GedcomLine gedcomLine = (GedcomLine)treeNode.getObject();
            GedcomTag gedcomTag = gedcomLine.getTag();
            if (!gedcomTag.equals((Object)GedcomTag.HEAD)) continue;
            root = this.parseHead(treeNode);
            break;
        }
        HashMap<String, Source> mapIDtoSource = new HashMap<String, Source>();
        for (TreeNode treeNode : rNodeTop) {
            GedcomLine gedcomLine = (GedcomLine)treeNode.getObject();
            GedcomTag tagTop3 = gedcomLine.getTag();
            if (!tagTop3.equals((Object)GedcomTag.SOUR)) continue;
            Source source = this.parseSource(treeNode);
            this.mapNodeToSource.put(treeNode, source);
            mapIDtoSource.put(source.getID(), source);
        }
        HashMap<String, Person> hashMap = new HashMap<String, Person>();
        for (TreeNode treeNode : rNodeTop) {
            lineTop = (GedcomLine)treeNode.getObject();
            tagTop = lineTop.getTag();
            if (!tagTop.equals((Object)GedcomTag.INDI)) continue;
            Person person = this.parseIndividual(treeNode, mapIDtoSource);
            this.people.add(person);
            this.mapNodeToPerson.put(treeNode, person);
            hashMap.put(person.getID(), person);
            this.storeInUuidMap(person);
            if (this.first != null && !person.getID().equals(root)) continue;
            this.first = person;
        }
        for (TreeNode treeNode : rNodeTop) {
            lineTop = (GedcomLine)treeNode.getObject();
            tagTop = lineTop.getTag();
            if (!tagTop.equals((Object)GedcomTag.FAM)) continue;
            this.parseFamily(treeNode, hashMap, mapIDtoSource);
        }
        this.people.forEach(Person::initKeyDates);
        this.people.forEach(Person::sortPartnerships);
        this.people.sort((p1, p2) -> this.sorter.compare(p1.getNameSortable(), p2.getNameSortable()));
    }

    public List<Person> getAllPeople() {
        return Collections.unmodifiableList(this.people);
    }

    private Collator sorter() {
        Collator c = Collator.getInstance();
        c.setDecomposition(2);
        c.setStrength(0);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public GedcomTree getGedcom() {
        return this.gedcom;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public Person getFirstPerson() {
        return this.first;
    }

    public Person lookUpPerson(UUID uuid) {
        return this.mapUUIDtoPerson.get(uuid);
    }

    public Person lookUpPerson(TreeNode<GedcomLine> node) {
        return this.mapNodeToPerson.get(node);
    }

    public Partnerships lookUpFamily(TreeNode<GedcomLine> node) {
        return this.mapNodeToPartnerships.get(node);
    }

    public Event lookUpEvent(TreeNode<GedcomLine> node) {
        return this.mapNodeToEvent.get(node);
    }

    public Source lookUpSource(TreeNode<GedcomLine> node) {
        return this.mapNodeToSource.get(node);
    }

    public void appendAllUuids(Set<UUID> appendTo) {
        appendTo.addAll(this.mapUUIDtoPerson.keySet());
    }

    private void storeInUuidMap(Person person) {
        UUID uuid = person.getUuid();
        if (uuid == null) {
            return;
        }
        Person existing = this.mapUUIDtoPerson.get(uuid);
        if (existing != null) {
            System.err.println("Duplicate INDI UUID value: " + uuid);
            return;
        }
        this.mapUUIDtoPerson.put(uuid, person);
    }

    private static void getChildren(TreeNode<GedcomLine> root, Collection<TreeNode<GedcomLine>> rNodeTop) {
        for (TreeNode<GedcomLine> treeNode : root) {
            rNodeTop.add(treeNode);
        }
    }

    private String parseHead(TreeNode<GedcomLine> head) {
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(head, rNode);
        String root = "";
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (tag.equals((Object)GedcomTag.NOTE)) {
                this.description = line.getValue();
                continue;
            }
            if (line.getTag().equals((Object)GedcomTag.COPR)) {
                this.copyright = line.getValue();
                continue;
            }
            if (!line.getTagString().equals("_ROOT")) continue;
            root = line.getPointer();
        }
        return root;
    }

    private Source parseSource(TreeNode<GedcomLine> nodeSource) {
        String author = "";
        String title = "";
        String publication = "";
        String text = "";
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(nodeSource, rNode);
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (tag.equals((Object)GedcomTag.AUTH)) {
                author = line.getValue();
                continue;
            }
            if (tag.equals((Object)GedcomTag.TITL)) {
                title = line.getValue();
                continue;
            }
            if (tag.equals((Object)GedcomTag.PUBL)) {
                publication = line.getValue();
                continue;
            }
            if (!tag.equals((Object)GedcomTag.TEXT)) continue;
            text = line.getValue();
        }
        return new Source(nodeSource.getObject().getID(), author, title, publication, text);
    }

    private Person parseIndividual(TreeNode<GedcomLine> nodeIndi, Map<String, Source> mapIDtoSource) {
        GedcomTag tag;
        GedcomLine line;
        String name = "";
        UUID uuid = null;
        ArrayList<Event> rEvent = new ArrayList<Event>();
        boolean isPrivate = false;
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(nodeIndi, rNode);
        Event birth = null;
        Event death = null;
        for (TreeNode treeNode : rNode) {
            line = (GedcomLine)treeNode.getObject();
            tag = line.getTag();
            if (!isPrivate && tag.equals((Object)GedcomTag.RESN)) {
                isPrivate = Loader.isPrivateRestriction(line.getValue());
            }
            if (tag.equals((Object)GedcomTag.BIRT)) {
                birth = this.parseEvent(treeNode, mapIDtoSource, false);
                continue;
            }
            if (!tag.equals((Object)GedcomTag.DEAT)) continue;
            death = this.parseEvent(treeNode, mapIDtoSource, false);
        }
        if (!isPrivate) {
            isPrivate = Loader.isRecentEnoughToPrivatize(birth, death);
        }
        for (TreeNode treeNode : rNode) {
            line = (GedcomLine)treeNode.getObject();
            tag = line.getTag();
            if (uuid == null && Loader.hasUuidTag(line)) {
                uuid = Loader.parseUuid(treeNode);
                continue;
            }
            if (!this.isEventish(tag)) continue;
            if (tag.equals((Object)GedcomTag.NAME) && name.isEmpty()) {
                name = Loader.parseName(treeNode);
            }
            Event event = this.parseEvent(treeNode, mapIDtoSource, isPrivate);
            this.mapNodeToEvent.put(treeNode, event);
            rEvent.add(event);
        }
        if (name.isEmpty()) {
            name = "[unknown]";
        }
        if (uuid == null) {
            Jul.log().warning("Cannot find REFN UUID for individual \"" + name + "\"; will generate temporary UUID.");
        }
        return new Person(nodeIndi.getObject().getID(), name, rEvent, new ArrayList<Partnership>(), isPrivate, uuid);
    }

    private boolean isEventish(GedcomTag tag) {
        return GedcomTag.setIndividualEvent.contains((Object)tag) || GedcomTag.setIndividualAttribute.contains((Object)tag) || tag.equals((Object)GedcomTag.NOTE) || tag.equals((Object)GedcomTag.NAME) || tag.equals((Object)GedcomTag.SEX);
    }

    private static boolean hasUuidTag(GedcomLine line) {
        if (line.getTag().equals((Object)GedcomTag.REFN)) {
            return true;
        }
        if (!line.getTag().equals((Object)GedcomTag.UNKNOWN)) {
            return false;
        }
        return line.getTagString().equals("_UID");
    }

    private static UUID parseUuid(TreeNode<GedcomLine> nodeUuid) {
        try {
            return UUID.fromString(nodeUuid.getObject().getValue());
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private void parseFamily(TreeNode<GedcomLine> nodeFam, Map<String, Person> mapIDtoPerson, Map<String, Source> mapIDtoSource) {
        Person husb = null;
        Person wife = null;
        boolean isPrivate = false;
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(nodeFam, rNode);
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            Object tag = line.getTag();
            if (tag.equals((Object)GedcomTag.HUSB)) {
                husb = Loader.lookUpPerson(line.getPointer(), mapIDtoPerson);
            } else if (tag.equals((Object)GedcomTag.WIFE)) {
                wife = Loader.lookUpPerson(line.getPointer(), mapIDtoPerson);
            }
            if (!isPrivate && tag.equals((Object)GedcomTag.RESN)) {
                isPrivate = Loader.isPrivateRestriction(line.getValue());
            }
            if (isPrivate || !tag.equals((Object)GedcomTag.MARR)) continue;
            Event event = this.parseEvent(treeNode, mapIDtoSource, false);
            isPrivate = Loader.isRecentEnoughToPrivatize(event, null);
        }
        ArrayList<ParentChildRelation> husbandsChildren = new ArrayList<ParentChildRelation>();
        ArrayList<ParentChildRelation> arrayList = new ArrayList<ParentChildRelation>();
        ArrayList<Event> rEvent = new ArrayList<Event>();
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (tag.equals((Object)GedcomTag.CHIL)) {
                Person child = Loader.lookUpPerson(line.getPointer(), mapIDtoPerson);
                String frel = "";
                String mrel = "";
                for (TreeNode nodeSub : treeNode) {
                    GedcomLine lineSub = (GedcomLine)nodeSub.getObject();
                    String tagSub = lineSub.getTagString();
                    if (tagSub.equalsIgnoreCase("_FREL")) {
                        frel = lineSub.getValue();
                        continue;
                    }
                    if (!tagSub.equalsIgnoreCase("_MREL")) continue;
                    mrel = lineSub.getValue();
                }
                if (Objects.nonNull(husb)) {
                    husbandsChildren.add(ParentChildRelation.create(child, isPrivate, frel));
                    child.addFather(ParentChildRelation.create(husb, isPrivate, frel));
                }
                if (!Objects.nonNull(wife)) continue;
                arrayList.add(ParentChildRelation.create(child, isPrivate, mrel));
                child.addMother(ParentChildRelation.create(wife, isPrivate, mrel));
                continue;
            }
            if (!GedcomTag.setFamilyEvent.contains((Object)tag)) continue;
            Event event = this.parseEvent(treeNode, mapIDtoSource, isPrivate);
            this.mapNodeToEvent.put(treeNode, event);
            rEvent.add(event);
        }
        Partnerships partnerships = new Partnerships();
        if (Objects.nonNull(husb)) {
            Partnership partnership = new Partnership(rEvent, isPrivate);
            partnership.addChildRelations(husbandsChildren);
            if (Objects.nonNull(wife)) {
                partnership.setPartner(wife);
            }
            husb.getPartnerships().add(partnership);
            partnerships.husb = Optional.of(partnership);
        }
        if (Objects.nonNull(wife)) {
            Partnership partnership = new Partnership(rEvent, isPrivate);
            partnership.addChildRelations(arrayList);
            if (Objects.nonNull(husb)) {
                partnership.setPartner(husb);
            }
            wife.getPartnerships().add(partnership);
            partnerships.wife = Optional.of(partnership);
        }
        this.mapNodeToPartnerships.put(nodeFam, partnerships);
    }

    private static Person lookUpPerson(String id, Map<String, Person> mapIDtoPerson) {
        return mapIDtoPerson.get(id);
    }

    private static Source lookUpSource(String id, Map<String, Source> mapIDtoSource) {
        return mapIDtoSource.containsKey(id) ? mapIDtoSource.get(id) : new Source("", "", "", "", "");
    }

    private static String parseName(TreeNode<GedcomLine> nodeName) {
        return nodeName.getObject().getValue();
    }

    private Event parseEvent(TreeNode<GedcomLine> nodeEvent, Map<String, Source> mapIDtoSource, boolean isPrivate) {
        String whichEvent = Loader.getEventName(nodeEvent);
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(nodeEvent, rNode);
        DatePeriod date = null;
        String place = "";
        Object note = "";
        ArrayList<Citation> citations = new ArrayList<Citation>();
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (tag.equals((Object)GedcomTag.DATE)) {
                String sDate = line.getValue().trim();
                GedcomDateValueParser parser = new GedcomDateValueParser(new StringReader(sDate));
                try {
                    date = parser.parse();
                }
                catch (Exception e) {
                    if (!sDate.isEmpty()) {
                        System.err.println("Error while parsing \"" + sDate + "\"");
                        e.printStackTrace();
                    }
                    date = null;
                }
                continue;
            }
            if (tag.equals((Object)GedcomTag.PLAC)) {
                place = line.getValue();
                continue;
            }
            if (tag.equals((Object)GedcomTag.NOTE)) {
                String n = this.parseNote(treeNode);
                if (!((String)note).isEmpty() && !n.isEmpty()) {
                    note = (String)note + "\n";
                }
                note = (String)note + n;
                continue;
            }
            if (tag.equals((Object)GedcomTag.SOUR)) {
                Source source = Loader.lookUpSource(((GedcomLine)treeNode.getObject()).getPointer(), mapIDtoSource);
                String page = Loader.getSourcePtPage(treeNode);
                String text = Loader.getSourcePtText(treeNode);
                Set<MultimediaReference> attachments = this.getSourcePtAttachments(treeNode);
                Set<URI> links = this.getSourcePtLinks(treeNode);
                Optional<AncestryPersona> apid = Loader.getSourcePtApid(treeNode);
                citations.add(new Citation(source, page, text, attachments, links, Loader.thru(apid)));
                continue;
            }
            if (!tag.equals((Object)GedcomTag.RESN) || isPrivate) continue;
            isPrivate = Loader.isPrivateRestriction(line.getValue());
        }
        if (nodeEvent.getObject().getTag().equals((Object)GedcomTag.NOTE)) {
            note = this.parseNote(nodeEvent);
        } else if (!(nodeEvent.getObject().getValue().isEmpty() || nodeEvent.getObject().getTag().equals((Object)GedcomTag.NAME) || nodeEvent.getObject().getTag().equals((Object)GedcomTag.SEX))) {
            if (!((String)note).isEmpty()) {
                note = (String)note + "\n";
            }
            note = (String)note + nodeEvent.getObject().getValue();
        }
        return new Event(whichEvent, date, place, (String)note, citations, isPrivate);
    }

    private static boolean isPrivateRestriction(String valueOfResnLine) {
        String upperValue = valueOfResnLine.toUpperCase();
        return !upperValue.equals("LOCKED");
    }

    private static <T> T thru(Optional<T> v) {
        return v.orElse(null);
    }

    private static Optional<AncestryPersona> getSourcePtApid(TreeNode<GedcomLine> node) {
        for (TreeNode<GedcomLine> treeNode : node) {
            if (!treeNode.getObject().getTagString().equals("_APID")) continue;
            String v = treeNode.getObject().getValue();
            return AncestryPersona.of(v);
        }
        return Optional.empty();
    }

    private Set<URI> getSourcePtLinks(TreeNode<GedcomLine> node) {
        HashSet<URI> r = new HashSet<URI>();
        node.forAll(link -> {
            if (((GedcomLine)link.getObject()).getTagString().equals("_LINK")) {
                Loader.addIfUri(r, link);
            }
        });
        return r;
    }

    private static void addIfUri(Set<URI> r, TreeNode<GedcomLine> link) {
        try {
            r.add(new URI(link.getObject().getValue()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Set<MultimediaReference> getSourcePtAttachments(TreeNode<GedcomLine> node) {
        HashSet<MultimediaReference> r = new HashSet<MultimediaReference>();
        node.forAll(obje -> {
            TreeNode<GedcomLine> n;
            if (((GedcomLine)obje.getObject()).getTag().equals((Object)GedcomTag.OBJE) && ((GedcomLine)obje.getObject()).isPointer() && (n = this.gedcom.getNode(((GedcomLine)obje.getObject()).getPointer())) != null) {
                n.forAll(file -> {
                    String ref;
                    if (((GedcomLine)file.getObject()).getTag().equals((Object)GedcomTag.FILE) && !(ref = ((GedcomLine)file.getObject()).getValue()).isEmpty()) {
                        r.add(new MultimediaReference(ref));
                    }
                });
            }
        });
        return r;
    }

    private static String getSourcePtPage(TreeNode<GedcomLine> node) {
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(node, rNode);
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (!tag.equals((Object)GedcomTag.PAGE)) continue;
            return ((GedcomLine)treeNode.getObject()).getValue();
        }
        return "";
    }

    private static String getSourcePtText(TreeNode<GedcomLine> node) {
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(node, rNode);
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (!tag.equals((Object)GedcomTag.DATA)) continue;
            return Loader.parseData(treeNode);
        }
        return "";
    }

    private static String parseData(TreeNode<GedcomLine> node) {
        StringBuilder sb = new StringBuilder(256);
        ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
        Loader.getChildren(node, rNode);
        for (TreeNode treeNode : rNode) {
            GedcomLine line = (GedcomLine)treeNode.getObject();
            GedcomTag tag = line.getTag();
            if (!tag.equals((Object)GedcomTag.TEXT)) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(((GedcomLine)treeNode.getObject()).getValue());
        }
        return sb.toString();
    }

    private String parseNote(TreeNode<GedcomLine> node) {
        if (!node.getObject().isPointer()) {
            return node.getObject().getValue();
        }
        String id = node.getObject().getPointer();
        TreeNode<GedcomLine> nodeNote = this.gedcom.getNode(id);
        if (nodeNote == null) {
            return "";
        }
        return nodeNote.getObject().getValue();
    }

    private static boolean isRecentEnoughToPrivatize(Event event, Event death) {
        DatePeriod dpDeath;
        if (Objects.isNull(event)) {
            return false;
        }
        DatePeriod dpEvent = event.getDate();
        if (Objects.isNull(dpEvent) || dpEvent.equals(DatePeriod.UNKNOWN)) {
            return false;
        }
        if (Objects.nonNull(death) && Objects.nonNull(dpDeath = death.getDate()) && !dpDeath.equals(DatePeriod.UNKNOWN)) {
            return false;
        }
        return Loader.dateOfLatestPublicInformation().compareTo(dpEvent.getEndDate().getApproxDay()) < 0;
    }

    private static Time dateOfLatestPublicInformation() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -110);
        return new Time(cal.getTime());
    }

    private static String getEventName(TreeNode<GedcomLine> node) {
        GedcomTag tag = node.getObject().getTag();
        String eventName = "";
        if (tag.equals((Object)GedcomTag.NAME)) {
            eventName = "name";
        } else if (tag.equals((Object)GedcomTag.NOTE)) {
            eventName = "note";
        } else if (tag.equals((Object)GedcomTag.SEX)) {
            eventName = "sex";
        } else if (tag.equals((Object)GedcomTag.EVEN)) {
            ArrayList<TreeNode<GedcomLine>> rNode = new ArrayList<TreeNode<GedcomLine>>();
            Loader.getChildren(node, rNode);
            for (TreeNode treeNode : rNode) {
                GedcomLine line = (GedcomLine)treeNode.getObject();
                GedcomTag t = line.getTag();
                if (!t.equals((Object)GedcomTag.TYPE)) continue;
                eventName = line.getValue();
            }
        }
        if (eventName.isEmpty()) {
            eventName = EventNames.getName(tag);
        }
        if (tag.equals((Object)GedcomTag.NAME)) {
            return eventName + ": " + node.getObject().getValue();
        }
        if (tag.equals((Object)GedcomTag.SEX)) {
            return eventName + ": " + Loader.getSexName(node.getObject().getValue());
        }
        return eventName;
    }

    private static String getSexName(String value) {
        switch (value) {
            case "M": {
                return "male";
            }
            case "F": {
                return "female";
            }
            case "U": {
                return "unknown";
            }
        }
        return value;
    }

    public static class Partnerships {
        public Optional<Partnership> husb = Optional.empty();
        public Optional<Partnership> wife = Optional.empty();
    }
}

