/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.date;

import nu.mine.mosher.gedcom.date.DateRange;

public class DatePeriod
implements Comparable<DatePeriod> {
    private final DateRange dateStart;
    private final DateRange dateEnd;
    public static final DatePeriod UNKNOWN = new DatePeriod(DateRange.UNKNOWN);

    public DatePeriod(DateRange date) {
        this(date, date);
    }

    public DatePeriod(DateRange dateStart, DateRange dateEnd) {
        this.dateStart = dateStart == null ? DateRange.UNKNOWN : dateStart;
        this.dateEnd = dateEnd == null ? DateRange.UNKNOWN : dateEnd;
    }

    public DateRange getStartDate() {
        return this.dateStart;
    }

    public DateRange getEndDate() {
        return this.dateEnd;
    }

    public boolean isSingle() {
        return this.dateStart.equals(this.dateEnd);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatePeriod)) {
            return false;
        }
        DatePeriod that = (DatePeriod)object;
        return this.dateStart.equals(that.dateStart) && this.dateEnd.equals(that.dateEnd);
    }

    public int hashCode() {
        return this.dateStart.hashCode() ^ this.dateEnd.hashCode();
    }

    public String getTabularString() {
        if (this.isSingle()) {
            return this.dateStart.getTabularString();
        }
        return this.dateStart.getTabularString() + "/" + this.dateEnd.getTabularString();
    }

    public String toString() {
        if (this.isSingle()) {
            return this.dateStart.toString();
        }
        return this.dateStart.toString() + "-" + this.dateEnd.toString();
    }

    @Override
    public int compareTo(DatePeriod that) {
        DateRange thatDate;
        if (that == null) {
            return -1;
        }
        DateRange thisDate = this.dateStart.equals(DateRange.UNKNOWN) ? this.dateEnd : this.dateStart;
        DateRange dateRange = thatDate = that.dateStart.equals(DateRange.UNKNOWN) ? that.dateEnd : that.dateStart;
        if (thatDate.equals(DateRange.UNKNOWN)) {
            return -1;
        }
        if (thisDate.equals(DateRange.UNKNOWN)) {
            return 1;
        }
        return thisDate.compareTo(thatDate);
    }

    public boolean overlaps(DatePeriod periodTarget) {
        return this.dateStart.compareTo(periodTarget.dateEnd) <= 0 && periodTarget.dateStart.compareTo(this.dateEnd) <= 0;
    }
}

