/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import nu.mine.mosher.collection.TreeNode;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.GedcomParser;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.exception.InvalidLevel;
import nu.mine.mosher.logging.Jul;

public class GedcomTree {
    private Charset charset = null;
    private int maxLength = 0;
    private final TreeNode<GedcomLine> root;
    private final Map<String, TreeNode<GedcomLine>> mapIDtoNode = new HashMap<String, TreeNode<GedcomLine>>();
    private int prevLevel = -1;
    private TreeNode<GedcomLine> prevNode;
    private static final Map<Charset, String> mapCharsetToGedcom = Collections.unmodifiableMap(new HashMap<Charset, String>(){
        {
            this.put(Charset.forName("UTF-8"), "UTF-8");
            this.put(Charset.forName("UTF-16"), "UTF-16");
            this.put(Charset.forName("US-ASCII"), "ASCII");
        }
    });
    private static final String formDate = "dd MMM yyyy";
    private static final String formTime = "HH:mm:ss";

    public GedcomTree() {
        this.root = new TreeNode();
        this.prevNode = this.root;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        if (!mapCharsetToGedcom.containsKey(charset)) {
            Jul.log().warning("Cannot convert to encoding " + charset.name() + "; defaulting to UTF-8.");
            charset = Charset.forName("UTF-8");
        }
        for (TreeNode<GedcomLine> treeNode : this.root) {
            if (!treeNode.getObject().getTag().equals((Object)GedcomTag.HEAD)) continue;
            for (TreeNode<GedcomLine> treeNode2 : treeNode) {
                if (!treeNode2.getObject().getTag().equals((Object)GedcomTag.CHAR)) continue;
                treeNode2.setObject(treeNode2.getObject().replaceValue(mapCharsetToGedcom.get(charset)));
            }
        }
        this.charset = charset;
        Jul.log().info("Set output character encoding to " + this.charset.name());
    }

    void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void readFrom(GedcomParser parser) throws InvalidLevel {
        int i = 0;
        for (GedcomLine line : parser) {
            ++i;
            Jul.log().finest("parsed GEDCOM line: " + line);
            try {
                this.appendLine(line);
            }
            catch (InvalidLevel err) {
                Jul.log().warning("at line number " + i);
                throw err;
            }
        }
    }

    private void appendLine(GedcomLine line) throws InvalidLevel {
        int cPops = this.prevLevel + 1 - line.getLevel();
        if (cPops < 0) {
            throw new InvalidLevel(line);
        }
        TreeNode<GedcomLine> parent = this.prevNode;
        for (int i = 0; i < cPops; ++i) {
            parent = parent.parent();
        }
        this.prevLevel = line.getLevel();
        this.prevNode = new TreeNode();
        this.prevNode.setObject(line);
        parent.addChild(this.prevNode);
        if (line.hasID()) {
            this.mapIDtoNode.put(line.getID(), this.prevNode);
        }
    }

    public TreeNode<GedcomLine> getNode(String id) {
        return this.mapIDtoNode.get(id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        try {
            this.root.appendStringDeep(sb);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sb.toString();
    }

    public TreeNode<GedcomLine> getRoot() {
        return this.root;
    }

    public void timestamp() {
        Date now = new Date();
        SimpleDateFormat dfDate = new SimpleDateFormat(formDate);
        dfDate.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = dfDate.format(now).toUpperCase();
        SimpleDateFormat dfTime = new SimpleDateFormat(formTime);
        dfTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = dfTime.format(now);
        for (TreeNode<GedcomLine> treeNode : this.root) {
            if (!treeNode.getObject().getTag().equals((Object)GedcomTag.HEAD)) continue;
            GedcomTree.addOrUpdateChild(treeNode, GedcomTag.DATE, date);
            for (TreeNode<GedcomLine> treeNode2 : treeNode) {
                if (!treeNode2.getObject().getTag().equals((Object)GedcomTag.DATE)) continue;
                GedcomTree.addOrUpdateChild(treeNode2, GedcomTag.TIME, time);
            }
        }
    }

    public static void addOrUpdateChild(TreeNode<GedcomLine> nodeParent, GedcomTag tagChild, String valChild) {
        for (TreeNode<GedcomLine> treeNode : nodeParent) {
            GedcomLine lineChild = treeNode.getObject();
            if (!lineChild.getTag().equals((Object)tagChild)) continue;
            treeNode.setObject(lineChild.replaceValue(valChild));
            return;
        }
        nodeParent.addChild(new TreeNode<GedcomLine>(GedcomLine.create(nodeParent.getObject().getLevel() + 1, tagChild, valChild)));
    }
}

