/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import nu.mine.mosher.collection.TreeNode;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.GedcomTree;

public class GedcomDataRef {
    private final List<Tag> path;

    public GedcomDataRef(String expr) throws InvalidSyntax {
        this.path = GedcomDataRef.parse(expr);
    }

    public void forEach(GedcomTree tree, Consumer<TreeNode<GedcomLine>> fn) {
        this.forEachHelper(tree.getRoot(), 0, fn);
    }

    private void forEachHelper(TreeNode<GedcomLine> node, int level, Consumer<TreeNode<GedcomLine>> fn) {
        node.forEach(c -> {
            if (this.matches(level, (TreeNode<GedcomLine>)c)) {
                if (this.at(level)) {
                    fn.accept((TreeNode<GedcomLine>)c);
                } else {
                    this.forEachHelper((TreeNode<GedcomLine>)c, level + 1, fn);
                }
            }
        });
    }

    public boolean matches(int i, TreeNode<GedcomLine> node) {
        if (i < 0 || this.path.size() <= i) {
            return false;
        }
        Tag tagRef = this.path.get(i);
        if (tagRef.tagAsString.equals("*") || node.getObject().getTagString().toLowerCase().equals(tagRef.tagAsString)) {
            return this.matchesPattern(tagRef.pattern, node.getObject().getValue());
        }
        return false;
    }

    private boolean matchesPattern(Pattern pattern, String value) {
        if (pattern == null) {
            return true;
        }
        return pattern.matcher(value).matches();
    }

    public String get(int i) {
        if (i < 0 || this.path.size() <= i) {
            return "";
        }
        return this.path.get((int)i).tagAsString;
    }

    public boolean at(int i) {
        return i == this.path.size() - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        this.path.forEach(i -> {
            sb.append('.');
            sb.append(i);
        });
        return sb.toString();
    }

    private static ArrayList<Tag> parse(String expr) throws InvalidSyntax {
        ArrayList<Tag> path = new ArrayList<Tag>(8);
        boolean START = false;
        boolean TAG = true;
        int DOWN = 2;
        StreamTokenizer token = GedcomDataRef.tokenizer(expr);
        int state = 0;
        while (GedcomDataRef.next(token)) {
            switch (state) {
                case 0: {
                    if (token.ttype != 46) {
                        token.pushBack();
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if (token.ttype == 46) {
                        throw new InvalidSyntax();
                    }
                    path.add(new Tag(token.sval));
                    state = 2;
                    break;
                }
                case 2: {
                    if (token.ttype == 34) {
                        path.get(path.size() - 1).setPattern(token.sval);
                        break;
                    }
                    if (token.ttype != 46) {
                        throw new InvalidSyntax();
                    }
                    state = 1;
                }
            }
        }
        return path;
    }

    private static StreamTokenizer tokenizer(String expr) {
        StreamTokenizer t = new StreamTokenizer(new StringReader(expr));
        t.resetSyntax();
        t.slashSlashComments(false);
        t.slashStarComments(false);
        t.eolIsSignificant(false);
        t.lowerCaseMode(true);
        t.wordChars(48, 57);
        t.wordChars(65, 90);
        t.wordChars(97, 122);
        t.wordChars(95, 95);
        t.wordChars(42, 42);
        t.quoteChar(34);
        return t;
    }

    private static boolean next(StreamTokenizer t) {
        try {
            return t.nextToken() != -1;
        }
        catch (Throwable cannotHappen) {
            throw new IllegalStateException();
        }
    }

    private static class Tag {
        final String tagAsString;
        GedcomTag tag;
        Pattern pattern;

        Tag(String tag) {
            this.tagAsString = tag;
            try {
                this.tag = GedcomTag.valueOf(tag);
            }
            catch (Throwable e) {
                this.tag = null;
            }
        }

        void setPattern(String pattern) throws PatternSyntaxException {
            this.pattern = Pattern.compile(pattern);
        }
    }

    public static class InvalidSyntax
    extends Exception {
    }
}

