/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.util.ArrayList;
import java.util.logging.Logger;
import nu.mine.mosher.collection.TreeNode;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.GedcomTree;

public class GedcomConcatenator {
    private static final Logger log = Logger.getLogger("");
    private final GedcomTree tree;
    private int maxLength = 0;

    public GedcomConcatenator(GedcomTree tree) {
        this.tree = tree;
    }

    public void concatenate() {
        this.concatenateHelper(this.tree.getRoot());
        if (this.maxLength < 1) {
            this.maxLength = 60;
            log.info("Did not detect any CONC or CONT lines in this file; defaulting to " + this.maxLength);
        }
        this.tree.setMaxLength(this.maxLength);
        log.info("Detected maximum length for CONC/CONT line breaking of: " + Integer.toString(this.maxLength));
    }

    private void concatenateHelper(TreeNode<GedcomLine> nodeParent) {
        ArrayList<TreeNode<GedcomLine>> rToBeRemoved = new ArrayList<TreeNode<GedcomLine>>();
        for (TreeNode<GedcomLine> treeNode : nodeParent) {
            this.concatenateHelper(treeNode);
            GedcomLine lineChild = treeNode.getObject();
            GedcomTag tag = lineChild.getTag();
            switch (tag) {
                case CONT: {
                    if (this.maxLength < lineChild.getValue().length()) {
                        this.maxLength = lineChild.getValue().length();
                    }
                    nodeParent.setObject(nodeParent.getObject().contValue(lineChild.getValue()));
                    rToBeRemoved.add(treeNode);
                    break;
                }
                case CONC: {
                    if (this.maxLength < lineChild.getValue().length()) {
                        this.maxLength = lineChild.getValue().length();
                    }
                    nodeParent.setObject(nodeParent.getObject().concValue(lineChild.getValue()));
                    rToBeRemoved.add(treeNode);
                    break;
                }
            }
        }
        rToBeRemoved.forEach(TreeNode::removeFromParent);
    }
}

