/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.util.Objects;
import java.util.Optional;
import nu.mine.mosher.gedcom.model.Person;
import nu.mine.mosher.gedcom.model.Privatizable;

public class ParentChildRelation
implements Comparable<ParentChildRelation>,
Privatizable {
    private Person other;
    private Optional<String> relation = Optional.empty();
    private boolean isPrivate;

    public static ParentChildRelation of(Person other) {
        ParentChildRelation it = new ParentChildRelation();
        it.setOther(other);
        return it;
    }

    public static ParentChildRelation create(Person other, boolean isPrivate, String relation) {
        ParentChildRelation it = ParentChildRelation.of(other);
        it.setPrivate(isPrivate);
        it.setRelation(relation);
        return it;
    }

    public Person getOther() {
        return this.other;
    }

    public Optional<String> getRelation() {
        return this.relation;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setOther(Person other) {
        this.other = other;
    }

    public void setRelation(String relation) {
        this.relation = ParentChildRelation.parseRelation(relation);
    }

    public void setPrivate(boolean aPrivate) {
        this.isPrivate = aPrivate;
    }

    private static Optional<String> parseRelation(String relation) {
        if (Objects.isNull(relation)) {
            return Optional.empty();
        }
        if (relation.trim().isEmpty()) {
            return Optional.empty();
        }
        if (relation.trim().equalsIgnoreCase("natural")) {
            return Optional.empty();
        }
        return Optional.of(relation.trim());
    }

    @Override
    public int compareTo(ParentChildRelation that) {
        return this.other.compareTo(that.other);
    }
}

