/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import nu.mine.mosher.gedcom.model.AncestryPersona;
import nu.mine.mosher.gedcom.model.MultimediaReference;
import nu.mine.mosher.gedcom.model.Source;

public class Citation {
    private final Source source;
    private final String page;
    private final String extraText;
    private final Set<MultimediaReference> attachments;
    private final Set<URI> links;
    private final AncestryPersona apid;

    public Citation(Source source, String page, String extraText, Set<MultimediaReference> attachments, Set<URI> links, AncestryPersona apid) {
        this.source = source;
        this.page = page;
        this.extraText = extraText;
        this.attachments = Collections.unmodifiableSet(attachments);
        this.links = Collections.unmodifiableSet(links);
        this.apid = apid;
    }

    public Source getSource() {
        return this.source;
    }

    public String getPage() {
        return this.page;
    }

    public String getExtraText() {
        return this.extraText;
    }

    public Set<MultimediaReference> getAttachments() {
        return this.attachments;
    }

    public Set<URI> getLinks() {
        return this.links;
    }

    public Optional<AncestryPersona> getApid() {
        return Optional.ofNullable(this.apid);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Citation)) {
            return false;
        }
        Citation that = (Citation)object;
        return this.source.equals(that.source) && this.page.equals(that.page) && this.extraText.equals(that.extraText);
    }

    public int hashCode() {
        int h = 17;
        h *= 37;
        h += this.source.hashCode();
        h *= 37;
        h += this.page.hashCode();
        h *= 37;
        return h += this.extraText.hashCode();
    }
}

