/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.exception.GedcomParseException;
import nu.mine.mosher.gedcom.exception.IllegalLevel;
import nu.mine.mosher.gedcom.exception.InvalidID;
import nu.mine.mosher.gedcom.exception.MissingTag;

class GedcomParser
implements Iterable<GedcomLine> {
    private final BufferedReader in;

    public GedcomParser(BufferedReader in) {
        this.in = in;
    }

    @Override
    public Iterator<GedcomLine> iterator() {
        return new Iter();
    }

    private GedcomLine nextLine() throws GedcomParseException {
        String sLine = this.getNextNonblankLine();
        if (sLine == null) {
            return null;
        }
        return GedcomParser.parseLine(Normalizer.normalize(sLine, Normalizer.Form.NFD));
    }

    private String getNextNonblankLine() throws GedcomParseException {
        try {
            String s = this.in.readLine();
            while (s != null && s.trim().length() == 0) {
                s = this.in.readLine();
            }
            if (s != null && s.codePointAt(0) == 65279) {
                s = s.substring(1);
            }
            return s;
        }
        catch (IOException e) {
            throw new GedcomParseException("Error reading from input source.", e);
        }
    }

    private static GedcomLine parseLine(String sLine) throws IllegalLevel, MissingTag, InvalidID {
        String sTag;
        String sID;
        StringTokenizer st = new StringTokenizer(sLine);
        if (!st.hasMoreTokens()) {
            throw new IllegalLevel(sLine, new GedcomLine(-1, "", "", ""));
        }
        String sLevel = st.nextToken();
        int level = -1;
        try {
            level = Integer.parseInt(sLevel);
        }
        catch (NumberFormatException e) {
            level = -1;
        }
        if (!st.hasMoreTokens()) {
            throw new MissingTag(sLine, new GedcomLine(level, "", "", ""));
        }
        String sIDorTag = st.nextToken();
        if (sIDorTag.startsWith("@")) {
            sID = sIDorTag;
            if (!st.hasMoreTokens()) {
                throw new MissingTag(sLine, new GedcomLine(level, sID, "", ""));
            }
            sTag = st.nextToken();
        } else {
            sID = "";
            sTag = sIDorTag;
        }
        String sValue = "";
        if (st.hasMoreTokens()) {
            sValue = st.nextToken("\u0000");
            sValue = sValue.substring(1);
        }
        if (level < 0 || 99 < level) {
            throw new IllegalLevel(sLine, new GedcomLine(level, sID, sTag, sValue));
        }
        if (level > 0 && sID.length() > 0) {
            throw new InvalidID(sLine, new GedcomLine(level, sID, sTag, sValue));
        }
        return new GedcomLine(level, sID, sTag, sValue);
    }

    private class Iter
    implements Iterator<GedcomLine> {
        private GedcomLine lineNext;
        private GedcomParseException exception;

        private void prepareNext() {
            try {
                this.lineNext = GedcomParser.this.nextLine();
                this.exception = null;
            }
            catch (GedcomParseException e) {
                this.lineNext = null;
                this.exception = e;
            }
        }

        private void checkNext() throws NoSuchElementException {
            if (this.lineNext == null) {
                NoSuchElementException noElement = new NoSuchElementException();
                noElement.initCause(this.exception);
                throw noElement;
            }
        }

        public Iter() {
            this.prepareNext();
        }

        @Override
        public boolean hasNext() {
            return this.lineNext != null;
        }

        @Override
        public GedcomLine next() throws NoSuchElementException {
            this.checkNext();
            GedcomLine returned = this.lineNext;
            this.prepareNext();
            return returned;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

