/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.io.File;
import java.nio.charset.Charset;
import nu.mine.mosher.logging.Jul;
import nu.mine.mosher.mopper.Optional;

public class GedcomOptions {
    public boolean minimal = false;
    public boolean verbose = false;
    public boolean timestamp = false;
    public boolean utf8 = false;
    public Charset encoding;
    public Integer concToWidth;
    public boolean help = false;
    public File input = null;
    public boolean model = false;

    public void h() {
        this.help();
    }

    public void help() {
        this.help = true;
        System.err.println("Usage: java -jar gedcom-lib-all.jar [OPTION]... <in.ged >out.ged 2>ged.log");
        System.err.println("Process a GEDCOM file.");
        System.err.println("Options:");
        this.options();
    }

    protected void options() {
        String s = String.join((CharSequence)"\n", "-h, --help           Print this help", "-v, --verbose        Show verbose informational messages", "-s, --timestamp      Update .HEAD.DATE.TIME with the current time, in UTC.", "-u, --utf8           Convert output to UTF-8 encoding. RECOMMENDED.", "-e, --encoding[=ENC] Force input encoding to be ENC; do not detect it.", "-c, --conc[=WIDTH]   Rebuild CONC/CONT lines, formatting to maximum width WIDTH");
        System.err.println(s);
    }

    public void v() {
        this.verbose();
    }

    public void verbose() {
        Jul.verbose(true);
        Jul.log().config("Showing verbose log messages.");
    }

    public void minimal() {
        this.minimal = true;
    }

    public void s() {
        this.timestamp();
    }

    public void timestamp() {
        this.timestamp = true;
    }

    public void u() {
        this.utf8();
    }

    public void utf8() {
        this.utf8 = true;
    }

    public void e(@Optional String encoding) {
        this.encoding(encoding);
    }

    public void encoding(@Optional String encoding) {
        this.encoding = encoding.isEmpty() ? Charset.forName("windows-1252") : Charset.forName(encoding);
    }

    public void c(@Optional String width) {
        this.conc(width);
    }

    public void conc(@Optional String width) {
        if (width.isEmpty()) {
            this.concToWidth = 80;
        } else {
            try {
                this.concToWidth = Integer.valueOf(width);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("invalid width: " + width);
            }
        }
        if (this.concToWidth <= 0) {
            throw new IllegalArgumentException("width specified as " + width + ", but must be greater than 0");
        }
    }

    public void input(String gedcom) {
        this.input = new File(gedcom);
    }

    public void model() {
        this.model = true;
    }
}

