/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.text.BreakIterator;
import java.util.UUID;

public class Source {
    private final UUID uuid;
    private final String ID;
    private final String author;
    private final String title;
    private final String publication;
    private final String text;
    private final String shortName;

    public Source(String ID, String author, String title, String publication, String text, UUID uuid) {
        this.ID = ID;
        this.uuid = uuid == null ? UUID.randomUUID() : uuid;
        this.author = author;
        this.title = title;
        this.publication = publication;
        this.text = text;
        this.shortName = this.buildShortName();
    }

    public String getID() {
        return this.ID;
    }

    private String buildShortName() {
        if (this.title.length() == 0) {
            return this.title;
        }
        BreakIterator wordIter = BreakIterator.getWordInstance();
        wordIter.setText(this.title);
        int start = wordIter.first();
        StringBuilder sb = new StringBuilder(32);
        int iWord = 0;
        int end = wordIter.next();
        while (end != -1 && ++iWord < 15) {
            sb.append(this.title.substring(start, end));
            start = end;
            end = wordIter.next();
        }
        return sb.toString();
    }

    public String getAuthor() {
        return this.author;
    }

    public String getPublication() {
        return this.publication;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Source)) {
            return false;
        }
        Source that = (Source)object;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

