/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.date.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import nu.mine.mosher.gedcom.date.DatePeriod;
import nu.mine.mosher.gedcom.date.DateRange;
import nu.mine.mosher.gedcom.date.YMD;
import nu.mine.mosher.gedcom.date.parser.GedcomDateValueParserConstants;
import nu.mine.mosher.gedcom.date.parser.GedcomDateValueParserTokenManager;
import nu.mine.mosher.gedcom.date.parser.ParseException;
import nu.mine.mosher.gedcom.date.parser.SimpleCharStream;
import nu.mine.mosher.gedcom.date.parser.Token;

public class GedcomDateValueParser
implements GedcomDateValueParserConstants {
    public GedcomDateValueParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public DatePeriod parse() throws ParseException {
        try {
            return this.DateValue();
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Throwable w) {
            ParseException e = new ParseException();
            e.initCause(w);
            throw e;
        }
    }

    private static YMD julianToGregorian(YMD ymdJulian) {
        GregorianCalendar J = new GregorianCalendar();
        J.setGregorianChange(new Date(Long.MAX_VALUE));
        J.set(ymdJulian.getYear(), ymdJulian.getMonth() - 1, ymdJulian.getDay());
        Date date = J.getTime();
        GregorianCalendar G = new GregorianCalendar();
        G.setGregorianChange(new Date(Long.MIN_VALUE));
        G.setTime(date);
        return new YMD(G.get(1), G.get(2) + 1, G.get(5), false, true);
    }

    public final DatePeriod DateValue() throws ParseException, DateRange.DatesOutOfOrder {
        DatePeriod d;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: {
                d = this.DateInterp();
                break;
            }
            case 1: 
            case 2: {
                d = this.DatePeriod();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                d = this.DateRange();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                d = this.DateApprox();
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 33: {
                d = this.DateSingle();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(0);
        return d;
    }

    public final DatePeriod DateInterp() throws ParseException, DateRange.DatesOutOfOrder {
        this.jj_consume_token(10);
        this.S();
        DatePeriod d = this.DateSingle();
        this.S();
        this.DatePhrase();
        return d;
    }

    public final String DatePhrase() throws ParseException {
        Token text = this.jj_consume_token(32);
        return text.image;
    }

    public final DatePeriod DatePeriod() throws ParseException, DateRange.DatesOutOfOrder {
        YMD fromDate = null;
        YMD toDate = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                this.S();
                fromDate = this.Date();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 31: {
                        this.S();
                        this.jj_consume_token(2);
                        this.S();
                        toDate = this.Date();
                        break block0;
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                this.S();
                toDate = this.Date();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new DatePeriod(new DateRange(fromDate, fromDate), new DateRange(toDate, toDate));
    }

    public final DatePeriod DateRange() throws ParseException, DateRange.DatesOutOfOrder {
        YMD earliest = null;
        YMD latest = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                this.S();
                earliest = this.Date();
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                this.S();
                latest = this.Date();
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                this.S();
                earliest = this.Date();
                this.S();
                this.jj_consume_token(6);
                this.S();
                latest = this.Date();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new DatePeriod(new DateRange(earliest, latest));
    }

    public final DatePeriod DateApprox() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.S();
        YMD ymd = this.Date();
        return new DatePeriod(new DateRange(new YMD(ymd.getYear(), ymd.getMonth(), ymd.getDay(), true, ymd.isJulian())));
    }

    public final DatePeriod DateSingle() throws ParseException {
        YMD ymd = this.Date();
        return new DatePeriod(new DateRange(ymd));
    }

    public final YMD Date() throws ParseException {
        YMD ymd;
        if (this.jj_2_1(7)) {
            this.jj_consume_token(33);
            this.jj_consume_token(24);
            this.jj_consume_token(30);
            this.OS();
            ymd = this.DateGregor();
        } else if (this.jj_2_2(7)) {
            this.jj_consume_token(33);
            this.jj_consume_token(25);
            this.jj_consume_token(30);
            this.OS();
            ymd = this.DateJulian();
        } else if (this.jj_2_3(7)) {
            ymd = this.DateSlash();
        } else if (this.jj_2_4(7)) {
            ymd = this.DateGregor();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ymd;
    }

    public final YMD DateGregor() throws ParseException {
        int e = 1;
        YMD ymd = this.DateGregorRaw();
        if (this.jj_2_5(4)) {
            this.S();
            e = this.Epoch();
        }
        return new YMD(ymd.getYear() * e, ymd.getMonth(), ymd.getDay(), ymd.isCirca(), ymd.isJulian());
    }

    public final YMD DateJulian() throws ParseException {
        int e = 1;
        YMD ymd = this.DateJulianRaw();
        if (this.jj_2_6(2)) {
            this.S();
            e = this.Epoch();
        }
        return new YMD(ymd.getYear() * e, ymd.getMonth(), ymd.getDay(), ymd.isCirca(), ymd.isJulian());
    }

    public final YMD DateSlash() throws ParseException {
        int day = 0;
        int month = 0;
        int year = 0;
        if (this.jj_2_7(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    day = this.Day();
                    this.S();
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                }
            }
            month = this.MonthEngl();
            this.S();
        }
        year = this.YearSlash();
        return GedcomDateValueParser.julianToGregorian(new YMD(year, month, day));
    }

    public final YMD DateGregorRaw() throws ParseException {
        int day = 0;
        int month = 0;
        int year = 0;
        if (this.jj_2_8(7)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    day = this.Day();
                    this.S();
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                }
            }
            month = this.MonthEngl();
            this.S();
        }
        year = this.Year();
        return new YMD(year, month, day);
    }

    public final YMD DateJulianRaw() throws ParseException {
        int day = 0;
        int month = 0;
        int year = 0;
        if (this.jj_2_9(7)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    day = this.Day();
                    this.S();
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            month = this.MonthEngl();
            this.S();
        }
        year = this.YearJulian();
        return GedcomDateValueParser.julianToGregorian(new YMD(year, month, day));
    }

    public final int YearJulian() throws ParseException {
        int year;
        if (this.jj_2_10(2)) {
            year = this.YearSlash();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    year = this.Year();
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return year;
    }

    public final int YearSlash() throws ParseException {
        int year = this.Year();
        this.jj_consume_token(29);
        this.N();
        return year + 1;
    }

    public final int Year() throws ParseException {
        int year = this.N();
        if (year == 0) {
            throw new ParseException("year cannot be zero.");
        }
        return year;
    }

    public final int Day() throws ParseException {
        int day = this.N();
        return day;
    }

    public final int N() throws ParseException {
        this.jj_consume_token(28);
        return Integer.parseInt(this.token.image);
    }

    public final void S() throws ParseException {
        this.jj_consume_token(31);
    }

    public final void OS() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
    }

    public final int Epoch() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                return -1;
            }
            case 27: {
                this.jj_consume_token(27);
                return 1;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int MonthEngl() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.kind - 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_10() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3R_16() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(15)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(16)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(17)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(18)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(19)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(20)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(21)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(22)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(23)) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_13() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_3R_1()) {
            return true;
        }
        return this.jj_3R_2();
    }

    private boolean jj_3R_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(31)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_3R_1()) {
            return true;
        }
        return this.jj_3R_3();
    }

    private boolean jj_3R_9() {
        if (this.jj_3R_15()) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_8() {
        if (this.jj_3R_15()) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3_4() {
        return this.jj_3R_2();
    }

    private boolean jj_3R_6() {
        if (this.jj_3R_15()) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_19() {
        return this.jj_3R_16();
    }

    private boolean jj_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_9()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_8()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_16();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_6()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_7()) {
            return true;
        }
        return this.jj_scan_token(31);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_5();
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_10();
    }

    private boolean jj_3_3() {
        return this.jj_3R_4();
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_3() {
        if (this.jj_3R_12()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_2() {
        if (this.jj_3R_11()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_10() {
        return this.jj_3R_10();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{285210558, Integer.MIN_VALUE, 6, 56, 896, 0x10000000, 0x10000000, 0x10000000, 0x10000000, Integer.MIN_VALUE, 0xC000000, 0xFFF000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public GedcomDateValueParser(InputStream stream) {
        this(stream, null);
    }

    public GedcomDateValueParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new GedcomDateValueParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GedcomDateValueParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new GedcomDateValueParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new GedcomDateValueParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public GedcomDateValueParser(GedcomDateValueParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(GedcomDateValueParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[34];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 34; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        GedcomDateValueParser.jj_la1_init_0();
        GedcomDateValueParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

