/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nu.mine.mosher.gedcom.date.DatePeriod;
import nu.mine.mosher.gedcom.model.Citation;
import nu.mine.mosher.gedcom.model.Privatizable;

public class Event
implements Comparable<Event>,
Privatizable {
    private final String type;
    private final DatePeriod date;
    private final String place;
    private final String note;
    private final List<Citation> citations;
    private final boolean isPrivate;

    public Event(String type, DatePeriod date, String place, String note, List<Citation> citations) {
        this(type, date, place, note, citations, false);
    }

    public Event(String type, DatePeriod date, String place, String note, List<Citation> citations, boolean isPrivate) {
        this.type = type;
        this.date = Optional.ofNullable(date).orElse(DatePeriod.UNKNOWN);
        this.place = place;
        this.note = note;
        this.citations = Collections.unmodifiableList(new ArrayList<Citation>(citations));
        this.isPrivate = isPrivate;
    }

    public String getType() {
        return this.type;
    }

    public DatePeriod getDate() {
        return this.date;
    }

    public String getPlace() {
        return this.place;
    }

    public String getNote() {
        return this.note;
    }

    public List<Citation> getCitations() {
        return this.citations;
    }

    @Override
    public int compareTo(Event that) {
        if (this.date == null && that.date == null) {
            return 0;
        }
        if (this.date == null) {
            return 1;
        }
        if (that.date == null) {
            return -1;
        }
        return this.date.compareTo(that.date);
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }
}

