/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import nu.mine.mosher.collection.TreeNode;
import nu.mine.mosher.gedcom.GedcomLine;
import nu.mine.mosher.gedcom.GedcomTag;
import nu.mine.mosher.gedcom.GedcomTree;

public class GedcomUnconcatenator {
    public static final int DEFAULT_MAX_LENGTH = 60;
    private static final int KEEP_TRAILING_EMPTY_STRINGS = -999;
    private static final Pattern LINEBREAK = Pattern.compile("\\R");
    private final GedcomTree tree;
    private final int maxLength;

    public GedcomUnconcatenator(GedcomTree tree) {
        this.tree = tree;
        int m = tree.getMaxLength();
        this.maxLength = m != 0 ? m : 60;
    }

    public void unconcatenate() {
        this.unconcDeep(this.tree.getRoot());
    }

    private void unconcDeep(TreeNode<GedcomLine> node) {
        node.forEach(this::unconcDeep);
        this.unconc(node);
    }

    private void unconc(TreeNode<GedcomLine> node) {
        GedcomLine gedcomLine = node.getObject();
        if (this.needsWork(gedcomLine)) {
            ArrayList<GedcomLine> gedcomLinesToAdd = new ArrayList<GedcomLine>(8);
            GedcomUnconcatenator.splitToContConc(gedcomLine.getValue(), this.maxLength, gedcomLine.getLevel() + 1, gedcomLinesToAdd);
            GedcomUnconcatenator.addContConcChildren(gedcomLinesToAdd, node);
        }
    }

    private boolean needsWork(GedcomLine line) {
        return line != null && (line.getValue().length() > this.maxLength || LINEBREAK.matcher(line.getValue()).find());
    }

    private static void addContConcChildren(List<GedcomLine> lines, TreeNode<GedcomLine> node) {
        TreeNode<GedcomLine> insertionPoint = node.getFirstChildOrNull();
        boolean first = true;
        for (GedcomLine line : lines) {
            if (first) {
                first = false;
                node.setObject(node.getObject().replaceValue(line.getValue()));
                continue;
            }
            node.addChildBefore(new TreeNode<GedcomLine>(line), insertionPoint);
        }
    }

    private static void splitToContConc(String originalValue, int maxLen, int gedcomLevel, List<GedcomLine> gedcomLines) {
        for (String line : LINEBREAK.split(originalValue, -999)) {
            GedcomUnconcatenator.addLines(line, maxLen, gedcomLevel, gedcomLines);
        }
    }

    private static void addLines(String line, int maxLen, int gedcomLevel, List<GedcomLine> gedcomLines) {
        ArrayList<String> segments = new ArrayList<String>(8);
        GedcomUnconcatenator.splitLineIntoSegments(line, maxLen, segments);
        GedcomUnconcatenator.addSegments(segments, gedcomLevel, gedcomLines);
    }

    private static void addSegments(List<String> segments, int gedcomLevel, List<GedcomLine> gedcomLines) {
        GedcomTag tag = GedcomTag.CONT;
        for (String segment : segments) {
            gedcomLines.add(new GedcomLine(gedcomLevel, "", tag.name(), segment));
            tag = GedcomTag.CONC;
        }
    }

    public static void splitLineIntoSegments(String line, int maxLen, List<String> segments) {
        assert (0 < maxLen && maxLen < 100000);
        assert (segments != null);
        String s = line;
        Sanity sanity = Sanity.create(100000);
        while (s.length() > maxLen) {
            sanity.check();
            String[] lr = GedcomUnconcatenator.cut(s, GedcomUnconcatenator.findSplitPosition(s, maxLen));
            segments.add(lr[0]);
            s = lr[1];
        }
        segments.add(s);
    }

    private static int findSplitPosition(String line, int maxLen) {
        int pos = 0;
        if (pos <= 0) {
            pos = GedcomUnconcatenator.breakOnWord(line, maxLen, true);
        }
        if (pos <= 0) {
            pos = GedcomUnconcatenator.breakOnWord(line, maxLen, false);
        }
        if (pos <= 0) {
            pos = maxLen;
        }
        return pos;
    }

    private static int breakOnWord(String s, int maxLen, boolean within) {
        int pos;
        Sanity sanity = Sanity.create(100000);
        for (pos = maxLen; pos > 0 && (GedcomUnconcatenator.spL(s, pos) || within && GedcomUnconcatenator.spR(s, pos)); --pos) {
            sanity.check();
        }
        return pos;
    }

    private static boolean spL(String s, int pos) {
        return Character.isWhitespace(s.codePointBefore(pos));
    }

    private static boolean spR(String s, int pos) {
        return Character.isWhitespace(s.codePointAt(pos));
    }

    private static String[] cut(String s, int at) {
        return new String[]{s.substring(0, at), s.substring(at)};
    }

    public static class Sanity {
        private int sanity;

        private Sanity(int n) {
            this.sanity = n;
        }

        public static Sanity create(int n) {
            return new Sanity(n);
        }

        public void check() {
            --this.sanity;
            assert (this.sanity > 0);
            if (this.sanity <= 0) {
                throw new IllegalStateException("Possible infinte loop detected, and aborted.");
            }
        }
    }
}

