/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nu.mine.mosher.gedcom.GedcomConcatenator;
import nu.mine.mosher.gedcom.GedcomEncodingDetector;
import nu.mine.mosher.gedcom.GedcomMinimal;
import nu.mine.mosher.gedcom.GedcomOptions;
import nu.mine.mosher.gedcom.GedcomParser;
import nu.mine.mosher.gedcom.GedcomTree;
import nu.mine.mosher.gedcom.GedcomUnconcatenator;
import nu.mine.mosher.gedcom.exception.InvalidLevel;
import nu.mine.mosher.logging.Jul;
import nu.mine.mosher.mopper.ArgParser;

public final class Gedcom {
    private final GedcomOptions options;
    private final Processor proc;

    public static void main(String ... args) throws InvalidLevel, IOException {
        new Gedcom((GedcomOptions)new ArgParser((Object)new GedcomOptions()).parse(args), g -> true).main();
        System.out.flush();
        System.err.flush();
    }

    public Gedcom(GedcomOptions options, Processor proc) {
        this.options = options;
        this.proc = proc;
    }

    public void main() throws IOException, InvalidLevel {
        this.main(null);
    }

    public void main(File gedcom) throws InvalidLevel, IOException {
        GedcomTree tree;
        if (this.options.help) {
            return;
        }
        if (this.options.minimal) {
            Jul.log().info("Generating MINIMAL GEDCOM file.");
            tree = GedcomMinimal.minimal(this.options.encoding);
        } else {
            BufferedInputStream streamInput = gedcom == null ? Gedcom.getStandardInput() : Gedcom.getFileInput(gedcom);
            tree = Gedcom.readFile(streamInput, this.options.encoding);
        }
        if (this.options.concToWidth != null) {
            Jul.log().info("Concatenating CONC/CONT lines.");
            new GedcomConcatenator(tree).concatenate();
        }
        if (this.proc.process(tree)) {
            if (this.options.timestamp) {
                tree.timestamp();
            }
            if (this.options.concToWidth != null) {
                Integer width = this.options.concToWidth;
                if (width != null) {
                    Jul.log().info("Rebuilding CONC/CONT lines to specified width: " + width);
                    tree.setMaxLength(width);
                } else {
                    Jul.log().info("Rebuilding CONC/CONT lines to guessed width " + Integer.toString(tree.getMaxLength()));
                }
                new GedcomUnconcatenator(tree).unconcatenate();
            }
            if (this.options.utf8) {
                Jul.log().info("Converting to UTF-8 encoding for output.");
                tree.setCharset(Charset.forName("UTF-8"));
            }
            Gedcom.writeFile(tree, Gedcom.getStandardOutput());
        }
    }

    public static GedcomTree valueOf(String gedcom) throws IOException, InvalidLevel {
        return Gedcom.readFile(new BufferedInputStream(new ByteArrayInputStream(gedcom.getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
    }

    public static GedcomTree readFile(BufferedInputStream streamInput) throws IOException, InvalidLevel {
        return Gedcom.readFile(streamInput, null);
    }

    public static GedcomTree readFile(BufferedInputStream streamInput, Charset charsetForce) throws IOException, InvalidLevel {
        if (charsetForce == null) {
            charsetForce = new GedcomEncodingDetector(streamInput).detect();
        } else {
            Jul.log().info("Forcing input character encoding to " + charsetForce.name());
        }
        GedcomParser parser = new GedcomParser(new BufferedReader(new InputStreamReader((InputStream)streamInput, charsetForce)));
        GedcomTree tree = new GedcomTree();
        tree.readFrom(parser);
        tree.setCharset(charsetForce);
        return tree;
    }

    public static void writeFile(GedcomTree tree, BufferedOutputStream streamOutput) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)streamOutput, tree.getCharset()));
        out.write(tree.toString());
        out.flush();
    }

    private static BufferedInputStream getFileInput(File gedcom) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(gedcom));
    }

    private static BufferedInputStream getStandardInput() {
        return new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    }

    private static BufferedOutputStream getFileOutput(File gedcom) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(gedcom));
    }

    private static BufferedOutputStream getStandardOutput() {
        return new BufferedOutputStream(new FileOutputStream(FileDescriptor.out));
    }

    public static interface Processor {
        public boolean process(GedcomTree var1);
    }
}

