/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.ansel;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.List;
import nu.mine.mosher.gedcom.ansel.AnselCharacterMap;

public class GedcomAnselCharset
extends Charset {
    static final String name = "x-gedcom-ansel";

    public GedcomAnselCharset() {
        this(name, null);
    }

    public GedcomAnselCharset(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof GedcomAnselCharset;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoder(this, 1.0f, 1.0f){
            private final List<Integer> listCombining;
            private boolean combining;
            {
                this.listCombining = new ArrayList<Integer>();
                this.combining = false;
            }

            @Override
            protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                if (!this.combining) {
                    while (out.position() < out.limit() && this.listCombining.size() > 0) {
                        int cint = this.listCombining.remove(0);
                        out.put((char)cint);
                    }
                }
                while (in.hasRemaining() && out.position() < out.limit()) {
                    int bint = this.getChar(in);
                    char c = '\u0000';
                    this.combining = false;
                    boolean drop = false;
                    if (AnselCharacterMap.map.containsKey(bint)) {
                        int mappedUni = AnselCharacterMap.map.get(bint);
                        if (mappedUni < 0) {
                            drop = true;
                        } else {
                            c = (char)mappedUni;
                            if (c != '\u0000' && bint >= 224) {
                                this.listCombining.add(Integer.valueOf(c));
                                this.combining = true;
                            }
                        }
                    } else {
                        c = (char)bint;
                        c = (char)(c & 0xFF);
                    }
                    if (this.combining || drop) continue;
                    if (c != '\u0000') {
                        out.put(c);
                    }
                    while (out.position() < out.limit() && this.listCombining.size() > 0) {
                        int cint = this.listCombining.remove(0);
                        out.put((char)cint);
                    }
                }
                return in.hasRemaining() ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
            }

            private int getChar(ByteBuffer in) {
                int bint = in.get();
                return bint &= 0xFF;
            }
        };
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException("encoding to ANSEL is not supported.");
    }
}

