/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.gedcom.ansel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AnselCharacterMap {
    private static final String RESOURCE = "ansel.csv";
    public static final Map<Integer, Integer> map = Collections.unmodifiableMap(AnselCharacterMap.readMapFromResource("ansel.csv"));

    private static Map<Integer, Integer> readMapFromResource(String resource) {
        try {
            return AnselCharacterMap.tryReadMapFromResource(resource);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<Integer, Integer> tryReadMapFromResource(String resource) throws IOException {
        return new BufferedReader(new InputStreamReader(AnselCharacterMap.class.getResourceAsStream(resource))).lines().map(AnselCharacterMap::csv).map(Arrays::stream).map(m -> m.mapToInt(AnselCharacterMap::hex)).map(IntStream::boxed).map(m -> m.collect(Collectors.toList())).collect(Collectors.toMap(k -> (Integer)k.get(0), v -> (Integer)v.get(1)));
    }

    private static String[] csv(String s) {
        return s.split(",", -1);
    }

    private static Integer hex(String s) {
        try {
            return Integer.parseInt(s, 16);
        }
        catch (Throwable e) {
            return -1;
        }
    }
}

