/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.spark.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jibe.tools.testing.spark.Access;
import jibe.tools.testing.spark.resource.AbstractFileResolvingResource;
import jibe.tools.testing.spark.resource.AbstractResourceHandler;
import jibe.tools.testing.spark.resource.ClassPathResource;
import jibe.tools.testing.spark.resource.ClassPathResourceHandler;
import jibe.tools.testing.spark.resource.ExternalResource;
import jibe.tools.testing.spark.resource.ExternalResourceHandler;
import jibe.tools.testing.spark.route.RouteMatcherFactory;
import jibe.tools.testing.spark.servlet.FilterTools;
import jibe.tools.testing.spark.servlet.SparkApplication;
import jibe.tools.testing.spark.utils.IOUtils;
import jibe.tools.testing.spark.webserver.MatcherFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkFilter
implements Filter {
    public static final String APPLICATION_CLASS_PARAM = "applicationClass";
    private static final Logger LOG = LoggerFactory.getLogger(SparkFilter.class);
    private static List<AbstractResourceHandler> staticResourceHandlers = null;
    private static boolean staticResourcesSet = false;
    private static boolean externalStaticResourcesSet = false;
    private String filterPath;
    private MatcherFilter matcherFilter;

    public static void configureStaticResources(String folder) {
        if (!staticResourcesSet) {
            if (folder != null) {
                try {
                    ClassPathResource resource = new ClassPathResource(folder);
                    if (resource.getFile().isDirectory()) {
                        if (staticResourceHandlers == null) {
                            staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                        }
                        staticResourceHandlers.add(new ClassPathResourceHandler(folder, "index.html"));
                        LOG.info("StaticResourceHandler configured with folder = " + folder);
                    } else {
                        LOG.error("Static resource location must be a folder");
                    }
                }
                catch (IOException e) {
                    LOG.error("Error when creating StaticResourceHandler", (Throwable)e);
                }
            }
            staticResourcesSet = true;
        }
    }

    public static void configureExternalStaticResources(String folder) {
        if (!externalStaticResourcesSet) {
            if (folder != null) {
                try {
                    ExternalResource resource = new ExternalResource(folder);
                    if (resource.getFile().isDirectory()) {
                        if (staticResourceHandlers == null) {
                            staticResourceHandlers = new ArrayList<AbstractResourceHandler>();
                        }
                        staticResourceHandlers.add(new ExternalResourceHandler(folder, "index.html"));
                        LOG.info("External StaticResourceHandler configured with folder = " + folder);
                    } else {
                        LOG.error("External Static resource location must be a folder");
                    }
                }
                catch (IOException e) {
                    LOG.error("Error when creating external StaticResourceHandler", (Throwable)e);
                }
            }
            externalStaticResourcesSet = true;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Access.runFromServlet();
        SparkApplication application = this.getApplication(filterConfig);
        application.init();
        this.filterPath = FilterTools.getFilterPath(filterConfig);
        this.matcherFilter = new MatcherFilter(RouteMatcherFactory.get(), true, false);
    }

    protected SparkApplication getApplication(FilterConfig filterConfig) throws ServletException {
        try {
            String applicationClassName = filterConfig.getInitParameter(APPLICATION_CLASS_PARAM);
            Class<?> applicationClass = Class.forName(applicationClassName);
            return (SparkApplication)applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        final String relativePath = FilterTools.getRelativePath(httpRequest, this.filterPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug(relativePath);
        }
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(httpRequest){

            public String getRequestURI() {
                return relativePath;
            }
        };
        if (staticResourceHandlers != null) {
            for (AbstractResourceHandler staticResourceHandler : staticResourceHandlers) {
                AbstractFileResolvingResource resource = staticResourceHandler.getResource(httpRequest);
                if (resource == null || !resource.isReadable()) continue;
                IOUtils.copy(resource.getInputStream(), (OutputStream)response.getOutputStream());
                return;
            }
        }
        this.matcherFilter.doFilter((ServletRequest)requestWrapper, response, chain);
    }

    public void destroy() {
    }
}

