/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.spark.resource;

import java.net.MalformedURLException;
import jibe.tools.testing.spark.resource.AbstractFileResolvingResource;
import jibe.tools.testing.spark.resource.AbstractResourceHandler;
import jibe.tools.testing.spark.resource.ExternalResource;
import jibe.tools.testing.spark.utils.Assert;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceHandler
extends AbstractResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResourceHandler.class);
    private final String baseResource;
    private String welcomeFile;

    public ExternalResourceHandler(String baseResource) {
        this(baseResource, null);
    }

    public ExternalResourceHandler(String baseResource, String welcomeFile) {
        Assert.notNull(baseResource);
        this.baseResource = baseResource;
        this.welcomeFile = welcomeFile;
    }

    @Override
    protected AbstractFileResolvingResource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        try {
            path = URIUtil.canonicalPath((String)path);
            String addedPath = ExternalResourceHandler.addPaths(this.baseResource, path);
            ExternalResource resource = new ExternalResource(addedPath);
            if (resource.exists() && resource.isDirectory()) {
                resource = this.welcomeFile != null ? new ExternalResource(ExternalResourceHandler.addPaths(resource.getPath(), this.welcomeFile)) : null;
            }
            return resource != null && resource.exists() ? resource : null;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getClass().getSimpleName() + " when trying to get resource. " + e.getMessage());
            }
            return null;
        }
    }
}

