/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.spark.resource;

import java.net.MalformedURLException;
import jibe.tools.testing.spark.resource.AbstractFileResolvingResource;
import jibe.tools.testing.spark.resource.AbstractResourceHandler;
import jibe.tools.testing.spark.resource.ClassPathResource;
import jibe.tools.testing.spark.utils.Assert;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceHandler
extends AbstractResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathResourceHandler.class);
    private final String baseResource;
    private String welcomeFile;

    public ClassPathResourceHandler(String baseResource) {
        this(baseResource, null);
    }

    public ClassPathResourceHandler(String baseResource, String welcomeFile) {
        Assert.notNull(baseResource);
        this.baseResource = baseResource;
        this.welcomeFile = welcomeFile;
    }

    @Override
    protected AbstractFileResolvingResource getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(path);
        }
        try {
            path = URIUtil.canonicalPath((String)path);
            String addedPath = ClassPathResourceHandler.addPaths(this.baseResource, path);
            ClassPathResource resource = new ClassPathResource(addedPath);
            if (resource.exists() && resource.getFile().isDirectory()) {
                resource = this.welcomeFile != null ? new ClassPathResource(ClassPathResourceHandler.addPaths(resource.getPath(), this.welcomeFile)) : null;
            }
            return resource != null && resource.exists() ? resource : null;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getClass().getSimpleName() + " when trying to get resource. " + e.getMessage());
            }
            return null;
        }
    }
}

