/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.mock.time;

import javax.annotation.PostConstruct;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeService.class);
    private static volatile int OFFSET_IN_SECONDS = 0;

    public LocalDateTime now() {
        return LocalDateTime.now().plusSeconds(OFFSET_IN_SECONDS);
    }

    @PostConstruct
    private void init() {
        LOGGER.info("init");
    }

    public void set(LocalDateTime localTimeToSet) {
        OFFSET_IN_SECONDS = Seconds.secondsBetween((ReadableInstant)LocalDateTime.now().toDateTime(), (ReadableInstant)localTimeToSet.toDateTime()).getSeconds();
    }
}

