/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.mock.smtp.eml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailMessageImpl;
import jibe.tools.testing.mock.smtp.SmtpState;

public class EMLMailMessage
implements MailMessage {
    private static final Pattern PATTERN = Pattern.compile("(.*?): (.*)");
    private InputStream stream;
    private MailMessage delegate = new MailMessageImpl();
    private boolean isLoaded = false;

    public EMLMailMessage(InputStream file) {
        this.stream = file;
    }

    public EMLMailMessage(File file) {
        try {
            this.stream = new FileInputStream(file);
        }
        catch (FileNotFoundException fnf) {
            throw new RuntimeException(fnf);
        }
    }

    @Override
    public Iterator<String> getHeaderNames() {
        this.checkLoaded();
        return this.delegate.getHeaderNames();
    }

    private void checkLoaded() {
        if (!this.isLoaded) {
            this.loadFile();
            this.isLoaded = true;
        }
    }

    @Override
    public String[] getHeaderValues(String name) {
        this.checkLoaded();
        return this.delegate.getHeaderValues(name);
    }

    @Override
    public String getFirstHeaderValue(String name) {
        this.checkLoaded();
        return this.delegate.getFirstHeaderValue(name);
    }

    @Override
    public String getBody() {
        this.checkLoaded();
        return this.delegate.getBody();
    }

    @Override
    public void addHeader(String name, String value) {
        this.delegate.addHeader(name, value);
    }

    @Override
    public void appendHeader(String name, String value) {
        this.delegate.appendHeader(name, value);
    }

    @Override
    public void appendBody(String line) {
        this.delegate.appendBody(line);
    }

    private void loadFile() {
        Scanner scanner = new Scanner(this.stream);
        SmtpState state = SmtpState.DATA_HDR;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (state == SmtpState.DATA_HDR) {
                if (line.isEmpty()) {
                    state = SmtpState.DATA_BODY;
                    continue;
                }
                Matcher matcher = PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String headerName = matcher.group(1);
                String headerValue = matcher.group(2);
                this.addHeader(headerName, headerValue);
                continue;
            }
            this.appendBody(line);
        }
        scanner.close();
    }
}

