/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.mock.smtp.action;

import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailStore;
import jibe.tools.testing.mock.smtp.Response;
import jibe.tools.testing.mock.smtp.SmtpState;
import jibe.tools.testing.mock.smtp.action.Action;

public class List
implements Action {
    private Integer messageIndex = null;

    public List(String params) {
        try {
            Integer messageIndex = Integer.valueOf(params);
            if (messageIndex > -1) {
                this.messageIndex = messageIndex;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return "LIST";
    }

    @Override
    public Response response(SmtpState smtpState, MailStore mailStore, MailMessage currentMessage) {
        StringBuffer result = new StringBuffer();
        if (this.messageIndex != null && this.messageIndex < mailStore.getEmailCount()) {
            result.append("\n-------------------------------------------\n");
            result.append(mailStore.getMessage(this.messageIndex).toString());
        }
        result.append("There are ");
        result.append(mailStore.getEmailCount());
        result.append(" message(s).");
        return new Response(250, result.toString(), SmtpState.GREET);
    }
}

