/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.mock.smtp;

import jibe.tools.testing.mock.smtp.ServerOptions;
import jibe.tools.testing.mock.smtp.SmtpServer;

public class SmtpServerFactory {
    public static SmtpServer startServer() throws Exception {
        ServerOptions serverOptions = new ServerOptions();
        return SmtpServerFactory.startServer(serverOptions);
    }

    public static SmtpServer startServer(ServerOptions options) throws Exception {
        SmtpServer server = SmtpServerFactory.wireUpServer(options);
        SmtpServerFactory.wrapInShutdownHook(server);
        SmtpServerFactory.startServerThread(server);
        System.out.println("Dumbster SMTP Server started on port " + options.port + ".\n");
        return server;
    }

    private static SmtpServer wireUpServer(ServerOptions options) {
        SmtpServer server = new SmtpServer();
        server.setPort(options.port);
        server.setThreaded(options.threaded);
        server.setMailStore(options.mailStore);
        return server;
    }

    private static void wrapInShutdownHook(final SmtpServer server) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                server.stop();
            }
        });
    }

    private static void startServerThread(SmtpServer server) throws Exception {
        new Thread(server).start();
        int timeout = 1000;
        while (!server.isReady()) {
            try {
                Thread.sleep(1L);
                if (--timeout >= 1) continue;
                if (server.ioException != null) {
                    throw server.ioException;
                }
                throw new RuntimeException("Server could not be started.");
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

