/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.mock.smtp;

import jibe.tools.testing.mock.smtp.MailMessage;
import jibe.tools.testing.mock.smtp.MailStore;
import jibe.tools.testing.mock.smtp.Response;
import jibe.tools.testing.mock.smtp.SmtpState;
import jibe.tools.testing.mock.smtp.action.Action;
import jibe.tools.testing.mock.smtp.action.BlankLine;
import jibe.tools.testing.mock.smtp.action.Connect;
import jibe.tools.testing.mock.smtp.action.Data;
import jibe.tools.testing.mock.smtp.action.DataEnd;
import jibe.tools.testing.mock.smtp.action.Ehlo;
import jibe.tools.testing.mock.smtp.action.Expn;
import jibe.tools.testing.mock.smtp.action.Help;
import jibe.tools.testing.mock.smtp.action.List;
import jibe.tools.testing.mock.smtp.action.Mail;
import jibe.tools.testing.mock.smtp.action.NoOp;
import jibe.tools.testing.mock.smtp.action.Quit;
import jibe.tools.testing.mock.smtp.action.Rcpt;
import jibe.tools.testing.mock.smtp.action.Rset;
import jibe.tools.testing.mock.smtp.action.Unrecognized;
import jibe.tools.testing.mock.smtp.action.Vrfy;

class Request {
    private Action clientAction;
    private SmtpState state;
    private String params;

    Request(Action action, String params, SmtpState state) {
        this.clientAction = action;
        this.state = state;
        this.params = params;
    }

    private Request() {
    }

    public static Request initialRequest() {
        return new Request(new Connect(), "", SmtpState.CONNECT);
    }

    public static Request createRequest(SmtpState state, String message) {
        Request request = new Request();
        request.state = state;
        if (request.isInDataHeaderState()) {
            return Request.buildDataHeaderRequest(message, request);
        }
        if (request.isInDataBodyState()) {
            return Request.buildDataBodyRequest(message, request);
        }
        return Request.buildCommandRequest(message, request);
    }

    private static Request buildDataHeaderRequest(String message, Request request) {
        if (message.equals(".")) {
            request.clientAction = new DataEnd();
        } else if (message.length() < 1) {
            request.clientAction = new BlankLine();
        } else {
            request.clientAction = new Unrecognized();
            request.params = message;
        }
        return request;
    }

    private static Request buildDataBodyRequest(String message, Request request) {
        if (message.equals(".")) {
            request.clientAction = new DataEnd();
        } else {
            request.clientAction = new Unrecognized();
            request.params = message.length() < 1 ? "\n" : message;
        }
        return request;
    }

    private static Request buildCommandRequest(String message, Request request) {
        String su = message.toUpperCase();
        if (su.startsWith("EHLO ") || su.startsWith("HELO")) {
            request.clientAction = new Ehlo();
            Request.extractParams(message, request);
        } else if (su.startsWith("MAIL FROM:")) {
            request.clientAction = new Mail();
            request.params = message.substring(10);
        } else if (su.startsWith("RCPT TO:")) {
            request.clientAction = new Rcpt();
            request.params = message.substring(8);
        } else if (su.startsWith("DATA")) {
            request.clientAction = new Data();
        } else if (su.startsWith("QUIT")) {
            request.clientAction = new Quit();
        } else if (su.startsWith("RSET")) {
            request.clientAction = new Rset();
        } else if (su.startsWith("NOOP")) {
            request.clientAction = new NoOp();
        } else if (su.startsWith("EXPN")) {
            request.clientAction = new Expn();
        } else if (su.startsWith("VRFY")) {
            request.clientAction = new Vrfy();
        } else if (su.startsWith("HELP")) {
            request.clientAction = new Help();
        } else if (su.startsWith("LIST")) {
            Request.extractParams(message, request);
            request.clientAction = new List(request.params);
        } else {
            request.clientAction = new Unrecognized();
        }
        return request;
    }

    private static void extractParams(String message, Request request) {
        try {
            request.params = message.substring(5);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Response execute(MailStore mailStore, MailMessage message) {
        return this.clientAction.response(this.state, mailStore, message);
    }

    Action getClientAction() {
        return this.clientAction;
    }

    SmtpState getState() {
        return this.state;
    }

    public String getParams() {
        return this.params;
    }

    private boolean isInDataHeaderState() {
        return SmtpState.DATA_HDR == this.state;
    }

    private boolean isInDataBodyState() {
        return SmtpState.DATA_BODY == this.state;
    }
}

