/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.bdd.executions.web;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Objects;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClientProxy<T>
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceClientProxy.class);
    private final Client serviceClient;
    private final Class<T> serviceInterface;

    public ServiceClientProxy(Client serviceClient, Class<T> serviceInterface) {
        this.serviceClient = serviceClient;
        this.serviceInterface = serviceInterface;
    }

    public static <T> T newInstance(Client serviceClient, Class<T> serviceInterface) {
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, new ServiceClientProxy<T>(serviceClient, serviceInterface));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isHashCode(method)) {
            return Objects.hash(this.serviceInterface);
        }
        if (this.isEquals(method)) {
            return this.serviceInterface.equals(args[0]);
        }
        if (this.isToString(method)) {
            return this.serviceInterface.toString();
        }
        Optional<BindingOperationInfo> foundBindingOperationInfo = this.getBindingOperationInfo(method);
        if (!foundBindingOperationInfo.isPresent()) {
            throw new RuntimeException("could not get BindingOperationInfo for method: " + method);
        }
        BindingOperationInfo bindingOperationInfo = (BindingOperationInfo)foundBindingOperationInfo.get();
        Object[] returnValue = this.serviceClient.invoke(bindingOperationInfo, args);
        Object answer = null;
        if (returnValue.length == 1) {
            answer = returnValue[0];
        }
        return answer;
    }

    private boolean isHashCode(Method method) {
        return method.getName().equals("hashCode") && method.getDeclaringClass().equals(Object.class);
    }

    private boolean isEquals(Method method) {
        return method.getName().equals("equals") && method.getDeclaringClass().equals(Object.class);
    }

    private boolean isToString(Method method) {
        return method.getName().equals("toString") && method.getDeclaringClass().equals(Object.class);
    }

    private Optional<BindingOperationInfo> getBindingOperationInfo(Method method) {
        WebMethod annotation = method.getAnnotation(WebMethod.class);
        String operationName = method.getName();
        if (annotation != null) {
            if (annotation.exclude()) {
                return Optional.absent();
            }
            if (!Strings.isNullOrEmpty((String)annotation.operationName())) {
                operationName = annotation.operationName();
            }
        }
        Collection operations = this.serviceClient.getEndpoint().getEndpointInfo().getBinding().getOperations();
        final String finalOperationName = operationName;
        return Iterables.tryFind((Iterable)operations, (Predicate)new Predicate<BindingOperationInfo>(){

            public boolean apply(BindingOperationInfo input) {
                QName qName = input.getName();
                return finalOperationName.equalsIgnoreCase(qName.getLocalPart());
            }
        });
    }
}

