/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.bdd.executions.web;

import com.google.common.base.Throwables;
import java.net.URL;
import jibe.tools.bdd.api.AbstractExecution;
import jibe.tools.bdd.api.ExecutionContext;
import jibe.tools.testing.bdd.executions.web.ServiceClientProxy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;

public class CreateDynamicWebServiceClient<T>
extends AbstractExecution<T> {
    private final URL wsdlLocation;
    private final Class<T> serviceClass;
    private T serviceClient;

    public CreateDynamicWebServiceClient(URL wsdlLocation, Class<T> serviceClass) {
        this.wsdlLocation = wsdlLocation;
        this.serviceClass = serviceClass;
    }

    public T execute(ExecutionContext ctx) {
        if (this.serviceClient == null) {
            try {
                Client dynamicClient = JaxWsDynamicClientFactory.newInstance().createClient(this.wsdlLocation);
                this.serviceClient = ServiceClientProxy.newInstance(dynamicClient, this.serviceClass);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return this.serviceClient;
    }
}

