/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.bdd.executions.web;

import com.google.common.base.Optional;
import java.io.File;
import java.util.concurrent.TimeUnit;
import jibe.tools.bdd.api.AbstractExecution;
import jibe.tools.bdd.api.ExecutionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.seleniumhq.selenium.fluent.FluentWebDriver;

public abstract class AbstractWebExecution<T>
extends AbstractExecution {
    public static final String FLUENT_WEBDRIVER_KEY = AbstractWebExecution.class.getName() + ".fluentWebDriver";
    public static final String PHANTOMJS_BINARY_KEY = AbstractWebExecution.class.getName() + ".phantomJSBinary";
    public static final String PHANTOMJS_DRIVER_KEY = AbstractWebExecution.class.getName() + ".phantomJSDriver";

    public void preExecute(ExecutionContext ctx) {
        if (this.haveFluentWebDriver(ctx)) {
            return;
        }
        Object phantomjsBinary = ctx.get(PHANTOMJS_BINARY_KEY);
        if (phantomjsBinary instanceof String) {
            phantomjsBinary = new File((String)phantomjsBinary);
        }
        ThreadLocal<PhantomJSDriver> phantomJSDriverThreadLocal = new ThreadLocal<PhantomJSDriver>();
        phantomJSDriverThreadLocal.set(this.newPhantomJSDriver((File)phantomjsBinary));
        ThreadLocal<FluentWebDriver> fluentWebDriverThreadLocal = new ThreadLocal<FluentWebDriver>();
        fluentWebDriverThreadLocal.set(new FluentWebDriver((WebDriver)phantomJSDriverThreadLocal.get()));
        ctx.put(PHANTOMJS_DRIVER_KEY, phantomJSDriverThreadLocal);
        ctx.put(FLUENT_WEBDRIVER_KEY, fluentWebDriverThreadLocal);
    }

    public abstract T execute(ExecutionContext var1);

    protected FluentWebDriver getFluentWebDriver(ExecutionContext ctx) {
        return (FluentWebDriver)((ThreadLocal)ctx.get(FLUENT_WEBDRIVER_KEY)).get();
    }

    protected WebDriver getWebDriver(ExecutionContext ctx) {
        return (WebDriver)((ThreadLocal)ctx.get(PHANTOMJS_DRIVER_KEY)).get();
    }

    protected Optional<FluentWebDriver> findFluentWebDriver(ExecutionContext ctx) {
        return this.haveFluentWebDriver(ctx) ? Optional.of((Object)this.getFluentWebDriver(ctx)) : Optional.absent();
    }

    protected Optional<WebDriver> findWebDriver(ExecutionContext ctx) {
        return this.haveFluentWebDriver(ctx) ? Optional.of((Object)this.getWebDriver(ctx)) : Optional.absent();
    }

    private PhantomJSDriver newPhantomJSDriver(File phantomjsBinary) {
        if (!phantomjsBinary.exists() || !phantomjsBinary.canExecute()) {
            throw new RuntimeException("phantomjsBinary: '" + phantomjsBinary + "' is missing or not executable...");
        }
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("phantomjs.binary.path", phantomjsBinary.getAbsolutePath());
        PhantomJSDriver driver = new PhantomJSDriver((Capabilities)capabilities);
        driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        return driver;
    }

    private boolean haveFluentWebDriver(ExecutionContext ctx) {
        return ctx.find(FLUENT_WEBDRIVER_KEY).isPresent() && ((ThreadLocal)ctx.get(FLUENT_WEBDRIVER_KEY)).get() != null;
    }
}

