/*
 * Decompiled with CFR 0.152.
 */
package jibe.tools.testing.bdd.executions.smtp;

import com.google.common.base.Throwables;
import java.net.BindException;
import jibe.tools.bdd.api.AbstractExecution;
import jibe.tools.bdd.api.ExecutionContext;
import jibe.tools.testing.mock.smtp.ServerOptions;
import jibe.tools.testing.mock.smtp.SmtpServer;
import jibe.tools.testing.mock.smtp.SmtpServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartSmtpServer
extends AbstractExecution<SmtpServer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartSmtpServer.class);
    private final int port;

    public StartSmtpServer() {
        this(2525);
    }

    public StartSmtpServer(int port) {
        this.port = port;
    }

    public static void main(String[] args) {
        new StartSmtpServer().execute(null);
    }

    public SmtpServer execute(ExecutionContext ctx) {
        try {
            return SmtpServerFactory.startServer(new ServerOptions(new String[]{"" + this.port}));
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                LOGGER.error("bind exception... already started?");
                return null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }
}

