package jibe.tools.testing.mock.time;

import org.joda.time.LocalDateTime;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;

public class TimeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeService.class);

    private static volatile int OFFSET_IN_SECONDS = 0;

    public LocalDateTime now() {
        return LocalDateTime.now().plusSeconds(OFFSET_IN_SECONDS);
    }

    @PostConstruct
    private void init() {
        LOGGER.info("init");
    }

    public void set(LocalDateTime localTimeToSet) {
        OFFSET_IN_SECONDS = Seconds.secondsBetween(LocalDateTime.now().toDateTime(), localTimeToSet.toDateTime()).getSeconds();
    }
}
